/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.script;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import net.portswigger.browser.chromium.installer.Install4JUserNamespaceUtil;
import net.portswigger.devtools.client.impl.connection.local.process.chrome.binary.DevtoolsBinariesDirectory;
import net.portswigger.devtools.client.impl.connection.local.process.chrome.binary.DevtoolsBinariesInfo;

public class I4jScript_Internal_0 {
    private static final long serialVersionUID = 1L;

    static boolean unpackChromiumArchive(Context context) {
        try {
            context.getCompilerVariable("chromiumVersion");
            String string = context.getCompilerVariable("chromiumArchiveFilename");
            Path path = Paths.get((String)context.getVariable("sys.contentDir"), string);
            Path path2 = Paths.get((String)context.getVariable("sys.contentDir"), "burpbrowser");
            path2.toFile().mkdirs();
            DevtoolsBinariesInfo devtoolsBinariesInfo = DevtoolsBinariesInfo.unpackBinariesIfRequiredFrom((URL)path.toUri().toURL()).to(path2);
            DevtoolsBinariesDirectory devtoolsBinariesDirectory = DevtoolsBinariesDirectory.from((DevtoolsBinariesInfo)devtoolsBinariesInfo);
            if (Util.isLinux()) {
                int n;
                Path path3 = devtoolsBinariesDirectory.pathToChild("chrome-sandbox");
                if (Util.hasFullAdminRights()) {
                    UserPrincipalLookupService userPrincipalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
                    GroupPrincipal groupPrincipal = userPrincipalLookupService.lookupPrincipalByGroupName("root");
                    UserPrincipal userPrincipal = userPrincipalLookupService.lookupPrincipalByName("root");
                    PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path3, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                    posixFileAttributeView.setGroup(groupPrincipal);
                    posixFileAttributeView.setOwner(userPrincipal);
                    Runtime.getRuntime().exec("chmod u+s " + path3.toString());
                } else if (Install4JUserNamespaceUtil.isUserNamespaceCloneSupported() != Install4JUserNamespaceUtil.Install4JUserNsCloneStatus.SUPPORTED && (n = Util.showOptionDialog((String)String.format("Root permissions are required to properly configure the embedded browser sandbox!\n You can either restart the installer as root or run the following command as root post installation:\n 'sudo chown root:root %s && sudo chmod u+s %s'", path3, path3), (String[])new String[]{"Cancel", "Continue"}, (int)2)) == 0) {
                    context.cancel();
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

