/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.formcomponents;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentContainer;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.VariableReplacer;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractFormComponent
extends AbstractBean
implements FormComponent,
FormEnvironmentContainer {
    public static final Pattern MNEMONIC_PATTERN = Pattern.compile("&(\\w)");
    private boolean enabled = true;
    private Context context;
    private FormEnvironment formEnvironment;
    private boolean visible = true;

    public static String getTextWithoutMnemonics(String text) {
        return MNEMONIC_PATTERN.matcher(text).replaceFirst("$1");
    }

    public static int getMnemonicCharIndex(String text) {
        Matcher matcher = MNEMONIC_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    @Override
    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        FormPanel formPanel;
        ScreenEnvelope screenEnvelope;
        this.enabled = enabled;
        Object configurationObject = this.getConfigurationObject();
        if (configurationObject instanceof JComponent) {
            ((JComponent)configurationObject).setEnabled(enabled);
        }
        if (this.formEnvironment instanceof FormEnvironmentImpl && (screenEnvelope = (formPanel = ((FormEnvironmentImpl)this.formEnvironment).getFormPanel()).getScreenEnvelope()) != null) {
            screenEnvelope.formComponentEnabledChanged(this, enabled);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        ComponentTuple componentTuple;
        this.visible = visible;
        if (this.formEnvironment != null && (componentTuple = this.formEnvironment.getComponentTuple(this)) != null) {
            Container parent;
            this.setVisible(componentTuple.getLeftComponent(), visible);
            this.setVisible(componentTuple.getCenterComponent(), visible);
            this.setVisible(componentTuple.getRightComponent(), visible);
            JComponent centerComponent = componentTuple.getCenterComponent();
            if (centerComponent != null && (parent = centerComponent.getParent()) != null) {
                parent.revalidate();
            }
        }
    }

    private void setVisible(JComponent component, boolean visible) {
        if (component != null) {
            component.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void migrateIds(Map<String, String> oldIdToNewId) {
    }

    @Override
    public void requestFocus() {
        JComponent component;
        Object configurationObject = this.getConfigurationObject();
        if (configurationObject instanceof JComponent && (component = (JComponent)configurationObject).isFocusable()) {
            SwingUtilities.invokeLater(component::requestFocus);
        }
    }

    @Override
    public boolean hasUserInput() {
        return true;
    }

    @Override
    public JComponent createLeftComponent() {
        return null;
    }

    @Override
    public boolean isFillCenterVertical() {
        return false;
    }

    @Override
    public JComponent createRightComponent() {
        return null;
    }

    @Override
    public Object getConfigurationObject() {
        return null;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return null;
    }

    @Override
    public boolean checkCompleted() {
        return true;
    }

    @Override
    public void initialize() {
    }

    @Deprecated
    protected final void initalize() {
    }

    @Override
    public void formWillActivate() {
    }

    @Override
    public void formActivated() {
    }

    @Override
    public void formDeactivated() {
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        return true;
    }

    @Override
    public boolean handleUnattended() {
        return true;
    }

    protected Object getInitValue(Object defaultValue, String variableName, Class<?> valueClass) {
        Object value;
        Context context = this.getContext();
        Object object = value = context == null ? null : context.getVariable(variableName);
        if (value != null && valueClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        return defaultValue;
    }

    public String replaceFormVariables(String value) throws UndefinedVariableException {
        return this.replaceFormVariables(value, ReplacementMode.PLAIN, VariableErrorHandlingDescriptor.DEFAULT);
    }

    public String replaceFormVariables(String value, ReplacementMode replacementMode) throws UndefinedVariableException {
        return this.replaceFormVariables(value, replacementMode, VariableErrorHandlingDescriptor.DEFAULT);
    }

    public String replaceFormVariables(String value, VariableErrorHandlingDescriptor errorHandlingDescriptor) throws UndefinedVariableException {
        return this.replaceFormVariables(value, ReplacementMode.PLAIN, errorHandlingDescriptor);
    }

    public String replaceFormVariables(String value, ReplacementMode replacementMode, VariableErrorHandlingDescriptor errorHandlingDescriptor) throws UndefinedVariableException {
        if (this.formEnvironment != null) {
            return this.formEnvironment.replaceFormVariables(value, replacementMode, errorHandlingDescriptor);
        }
        return InstallerVariables.replaceVariables(value, replacementMode, errorHandlingDescriptor);
    }

    public String[] replaceFormVariables(String[] values) throws UndefinedVariableException {
        return this.replaceFormVariables(values, VariableErrorHandlingDescriptor.DEFAULT);
    }

    public String[] replaceFormVariables(String[] values, VariableErrorHandlingDescriptor errorHandlingDescriptor) throws UndefinedVariableException {
        if (this.formEnvironment instanceof FormEnvironmentImpl) {
            HashMap<String, VariableReplacer> variableReplacers = new HashMap<String, VariableReplacer>();
            variableReplacers.put("form:", (FormEnvironmentImpl)this.formEnvironment);
            return InstallerVariables.replaceVariables(values, errorHandlingDescriptor, variableReplacers);
        }
        return InstallerVariables.replaceVariables(values, errorHandlingDescriptor);
    }
}

