/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.firewall;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinFirewall;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.firewall.WindowsFirewallDirection;
import com.install4j.runtime.beans.actions.firewall.WindowsFirewallProtocol;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Properties;

public class AddWindowsFirewallRuleAction
extends SystemAutoUninstallInstallAction {
    private static final String PROPERTY_NAME_CREATED = "created";
    private static final String PROPERTY_NAME_EXECUTABLE = "executable";
    private static final String PROPERTY_NAME_RULE_NAME = "ruleName";
    private static final String PROPERTY_NAME_INCOMING = "incoming";
    private static final String PROPERTY_NAME_UDP = "udp";
    private static final String PROPERTY_NAME_GROUP = "group";
    private static final String PROPERTY_NAME_LOCAL_ADDRESSES = "localAddresses";
    private static final String PROPERTY_NAME_LOCAL_PORTS = "localPorts";
    private static final String PROPERTY_NAME_REMOTE_ADDRESSES = "remoteAddresses";
    private static final String PROPERTY_NAME_REMOTE_PORTS = "remotePorts";
    private String launcherId = "";
    private String executablePath = "";
    private WindowsFirewallDirection direction = WindowsFirewallDirection.INCOMING;
    private String ruleName = "";
    private String description = "";
    private String group = "${compiler:sys.fullName}";
    private WindowsFirewallProtocol protocol = WindowsFirewallProtocol.TCP;
    private String localPorts = "";
    private String localAddresses = "";
    private String remotePorts = "";
    private String remoteAddresses = "";
    private boolean domainProfile = true;
    private boolean privateProfile = true;
    private boolean publicProfile;
    private boolean avoidPublicProfile;
    private boolean onlyActiveProfiles;
    private transient boolean created;

    public String getLauncherId() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public String getExecutablePath() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.executablePath);
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public WindowsFirewallDirection getDirection() {
        return this.replaceWithTextOverride("direction", this.direction, WindowsFirewallDirection.class);
    }

    public void setDirection(WindowsFirewallDirection direction) {
        this.direction = direction;
    }

    public String getRuleName() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.ruleName);
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getDescription() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.group);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public WindowsFirewallProtocol getProtocol() {
        return this.replaceWithTextOverride("protocol", this.protocol, WindowsFirewallProtocol.class);
    }

    public void setProtocol(WindowsFirewallProtocol protocol) {
        this.protocol = protocol;
    }

    public String getLocalPorts() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.localPorts);
    }

    public void setLocalPorts(String localPorts) {
        this.localPorts = localPorts;
    }

    public String getLocalAddresses() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.localAddresses);
    }

    public void setLocalAddresses(String localAddresses) {
        this.localAddresses = localAddresses;
    }

    public String getRemotePorts() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.remotePorts);
    }

    public void setRemotePorts(String remotePorts) {
        this.remotePorts = remotePorts;
    }

    public String getRemoteAddresses() {
        return AddWindowsFirewallRuleAction.replaceVariables(this.remoteAddresses);
    }

    public void setRemoteAddresses(String remoteAddresses) {
        this.remoteAddresses = remoteAddresses;
    }

    public boolean isDomainProfile() {
        return this.replaceWithTextOverride("domainProfile", this.domainProfile);
    }

    public void setDomainProfile(boolean domainProfile) {
        this.domainProfile = domainProfile;
    }

    public boolean isPrivateProfile() {
        return this.replaceWithTextOverride("privateProfile", this.privateProfile);
    }

    public void setPrivateProfile(boolean privateProfile) {
        this.privateProfile = privateProfile;
    }

    public boolean isPublicProfile() {
        return this.replaceWithTextOverride("publicProfile", this.publicProfile);
    }

    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    public boolean isAvoidPublicProfile() {
        return this.replaceWithTextOverride("avoidPublicProfile", this.avoidPublicProfile);
    }

    public void setAvoidPublicProfile(boolean avoidPublicProfile) {
        this.avoidPublicProfile = avoidPublicProfile;
    }

    public boolean isOnlyActiveProfiles() {
        return this.replaceWithTextOverride("onlyActiveProfiles", this.onlyActiveProfiles);
    }

    public void setOnlyActiveProfiles(boolean onlyActiveProfiles) {
        this.onlyActiveProfiles = onlyActiveProfiles;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        try {
            this.created = WinFirewall.addRule(this.createRule(context, this.getPersistentProperties()));
            Logger.getInstance().info(this, "created new rule: " + this.created);
            this.getPersistentProperties().setProperty(PROPERTY_NAME_CREATED, String.valueOf(this.created));
        }
        catch (WinFirewall.AccessDeniedException | WinFirewall.FirewallException | IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        return true;
    }

    private WinFirewall.Rule createRule(Context context, Properties storeToProperties) throws IOException {
        File usedExecutable;
        if (this.getLauncherId() == null) {
            usedExecutable = context.getDestinationFile(this.getExecutablePath());
        } else {
            LauncherSetup launcherSetup = context.getLauncherById(this.getLauncherId());
            if (launcherSetup == null) {
                throw new IOException("The launcher with ID " + this.getLauncherId() + " cannot be found");
            }
            usedExecutable = context.getDestinationFile(launcherSetup.getRelativeFileName());
        }
        EnumSet<WinFirewall.ProfileType> profileTypes = EnumSet.noneOf(WinFirewall.ProfileType.class);
        if (this.isDomainProfile()) {
            profileTypes.add(WinFirewall.ProfileType.DOMAIN);
        }
        if (this.isPrivateProfile()) {
            profileTypes.add(WinFirewall.ProfileType.PRIVATE);
        }
        if (this.isPublicProfile()) {
            profileTypes.add(WinFirewall.ProfileType.PUBLIC);
        }
        if (storeToProperties != null) {
            storeToProperties.setProperty(PROPERTY_NAME_EXECUTABLE, usedExecutable.getAbsolutePath());
            storeToProperties.setProperty(PROPERTY_NAME_RULE_NAME, this.getRuleName());
            storeToProperties.setProperty(PROPERTY_NAME_INCOMING, String.valueOf(this.getDirection() == WindowsFirewallDirection.INCOMING));
            storeToProperties.setProperty(PROPERTY_NAME_UDP, String.valueOf(this.getProtocol() == WindowsFirewallProtocol.UDP));
            storeToProperties.setProperty(PROPERTY_NAME_GROUP, this.getGroup());
            storeToProperties.setProperty(PROPERTY_NAME_LOCAL_ADDRESSES, this.getLocalAddresses());
            storeToProperties.setProperty(PROPERTY_NAME_LOCAL_PORTS, this.getLocalPorts());
            storeToProperties.setProperty(PROPERTY_NAME_REMOTE_ADDRESSES, this.getRemoteAddresses());
            storeToProperties.setProperty(PROPERTY_NAME_REMOTE_PORTS, this.getRemotePorts());
        }
        return new WinFirewall.Rule(usedExecutable.getAbsolutePath(), this.getRuleName(), this.getDirection().getRuleDirection(), this.getProtocol().getNetworkProtocol()).setGroupName(this.getGroup()).setDescription(this.getDescription()).setLocalAddresses(this.getLocalAddresses()).setLocalPorts(this.getLocalPorts()).setRemotePorts(this.getRemotePorts()).setRemoteAddresses(this.getRemoteAddresses()).setProfileTypes(profileTypes).setAvoidPublicProfile(this.isAvoidPublicProfile()).setOnlyActiveProfiles(this.isOnlyActiveProfiles());
    }

    @Override
    public void rollback(InstallerContext context) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        if (this.created) {
            try {
                int deleted = WinFirewall.deleteRules(this.createRule(context, null));
                Logger.getInstance().info(this, "deleted " + deleted + " firewall rules.");
            }
            catch (WinFirewall.AccessDeniedException | WinFirewall.FirewallException | IOException e) {
                Logger.getInstance().log(e);
            }
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Properties properties = this.getPersistentProperties();
        String created = properties.getProperty(PROPERTY_NAME_CREATED);
        if (created == null) {
            return true;
        }
        try {
            boolean removeOnlyCreated = CompilerVariableHelper.getCompilerExtensionVariable((Context)context, "firewallRemoveOnlyCreated", false);
            if (!removeOnlyCreated || Objects.equals(created, String.valueOf(true))) {
                WinFirewall.Rule rule = new WinFirewall.Rule(properties.getProperty(PROPERTY_NAME_EXECUTABLE, ""), properties.getProperty(PROPERTY_NAME_RULE_NAME, ""), Boolean.parseBoolean(properties.getProperty(PROPERTY_NAME_INCOMING, "true")) ? WinFirewall.RuleDirection.INCOMING : WinFirewall.RuleDirection.OUTGOING, Boolean.parseBoolean(properties.getProperty(PROPERTY_NAME_UDP, "false")) ? WinFirewall.NetworkProtocol.UDP : WinFirewall.NetworkProtocol.TCP).setGroupName(properties.getProperty(PROPERTY_NAME_GROUP, "")).setLocalAddresses(properties.getProperty(PROPERTY_NAME_LOCAL_ADDRESSES, "")).setLocalPorts(properties.getProperty(PROPERTY_NAME_LOCAL_PORTS, "")).setRemotePorts(properties.getProperty(PROPERTY_NAME_REMOTE_PORTS, "")).setRemoteAddresses(properties.getProperty(PROPERTY_NAME_REMOTE_ADDRESSES, ""));
                int deleted = WinFirewall.deleteRules(rule);
                Logger.getInstance().info(this, "deleted " + deleted + " firewall rules.");
            }
            return true;
        }
        catch (WinFirewall.AccessDeniedException | WinFirewall.FirewallException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }
}

