/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AbstractListComponent;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListComponent
extends AbstractListComponent
implements ListSelectionListener {
    private int visibleRows = 4;
    private boolean fillVertical = false;
    private boolean scrollable = true;
    private boolean multiSelection = true;
    private JList<String> list;

    public int getVisibleRows() {
        return this.replaceWithTextOverride("visibleRows", this.visibleRows);
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    public boolean isScrollable() {
        return this.replaceWithTextOverride("scrollable", this.scrollable);
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public boolean isMultiSelection() {
        return this.replaceWithTextOverride("multiSelection", this.multiSelection);
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.list != null && formEnvironment != null) {
            this.list.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.list = new JList<String>(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.list.setVisibleRowCount(this.getVisibleRows());
        int selectionMode = this.isMultiSelection() ? 2 : 0;
        this.list.setSelectionMode(selectionMode);
        if (this.isScrollable()) {
            JScrollPane scrollPane = new JScrollPane(this.list){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            scrollPane.setAlignmentX(0.0f);
            this.adjustMinimumSize(scrollPane.getViewport(), this.list);
            return scrollPane;
        }
        this.list.setAlignmentX(0.0f);
        this.list.setBorder(BorderFactory.createEtchedBorder());
        this.adjustMinimumSize(this.list, this.list);
        return this.list;
    }

    @Override
    public void initialize() {
        String[] listEntries;
        super.initialize();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String listEntry : listEntries = this.getListEntries()) {
            model.addElement(listEntry);
        }
        this.list.setModel(model);
        this.list.removeListSelectionListener(this);
        this.initList(listEntries);
        this.list.addListSelectionListener(this);
        this.selectionChanged();
    }

    private void initList(String[] listEntries) {
        if (listEntries != null) {
            Object varValue = this.getContext().getVariable(this.getVariableName());
            if (varValue instanceof Integer) {
                int selIndex = (Integer)varValue;
                if (selIndex < listEntries.length && selIndex >= 0) {
                    this.list.setSelectedIndex(selIndex);
                }
            } else if (this.isMultiSelection() && varValue instanceof int[]) {
                int[] selIndices = (int[])varValue;
                boolean ok = true;
                for (int index : selIndices) {
                    if (index < listEntries.length && index >= 0) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    this.list.setSelectedIndices(selIndices);
                }
            } else {
                int initiallySelectedIndex = this.getInitiallySelectedIndex();
                if (initiallySelectedIndex < listEntries.length) {
                    this.list.setSelectedIndex(initiallySelectedIndex);
                }
            }
        }
    }

    @Override
    public Object getConfigurationObject() {
        return this.list;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JList.class;
    }

    @Override
    public boolean checkCompleted() {
        Object value = this.isMultiSelection() ? this.list.getSelectedIndices() : (Object)this.list.getSelectedIndex();
        this.getContext().setVariable(this.getVariableName(), value);
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    protected boolean isLeadingLabelTopAligned() {
        return true;
    }

    @Override
    protected boolean getInitialFillHorizontal() {
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String[] descriptions = new String[this.list.getModel().getSize()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = this.list.getModel().getElementAt(i);
        }
        if (this.isMultiSelection()) {
            int[] newValues = console.askMultipleSelection(this.getConsoleLabelText(false), descriptions, null, this.list.getSelectedIndices(), true);
            this.list.setSelectedIndices(newValues);
        } else {
            int newValue = console.askOption(this.getConsoleLabelText(false), descriptions, null, this.list.getSelectedIndex(), true, true);
            this.list.setSelectedIndex(newValue);
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.list) {
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        this.selectionChanged(this.list.getSelectedValue(), this.list.getSelectedIndex());
    }
}

