/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AxisType;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.SelectionScriptHolder;
import com.install4j.runtime.installer.helper.Logger;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadiobuttonsComponent
extends LeadingLabelComponent
implements SelectionScriptHolder {
    private String variableName = "";
    private String[] radioButtonLabels;
    private int initiallySelectedIndex;
    private AxisType axisType = AxisType.VERTICAL;
    private ButtonGroup buttonGroup;
    private JRadioButton[] radioButtons;
    private ScriptProperty selectionScript;
    private boolean executeSelectionScriptWhenActivated = false;

    public String getVariableName() {
        return RadiobuttonsComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String[] getRadioButtonLabels() {
        return this.replaceWithTextOverride("radioButtonLabels", this.replaceFormVariables(this.radioButtonLabels), String[].class);
    }

    public void setRadioButtonLabels(String[] radioButtonLabels) {
        this.radioButtonLabels = radioButtonLabels;
    }

    public int getInitiallySelectedIndex() {
        return this.replaceWithTextOverride("initiallySelectedIndex", this.initiallySelectedIndex);
    }

    public void setInitiallySelectedIndex(int initiallySelectedIndex) {
        this.initiallySelectedIndex = initiallySelectedIndex;
    }

    public AxisType getAxisType() {
        return this.replaceWithTextOverride("axisType", this.axisType, AxisType.class);
    }

    public void setAxisType(AxisType axisType) {
        this.axisType = axisType;
    }

    @Override
    public ScriptProperty getSelectionScript() {
        return this.replaceWithTextOverride("selectionScript", this.selectionScript, ScriptProperty.class);
    }

    @Override
    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public boolean isExecuteSelectionScriptWhenActivated() {
        return this.replaceWithTextOverride("executeSelectionScriptWhenActivated", this.executeSelectionScriptWhenActivated);
    }

    @Override
    public void setExecuteSelectionScriptWhenActivated(boolean executeSelectionScriptWhenActivated) {
        this.executeSelectionScriptWhenActivated = executeSelectionScriptWhenActivated;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            elements.nextElement().setEnabled(enabled);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        int initIndex = (Integer)this.getInitValue(this.getInitiallySelectedIndex(), this.getVariableName(), Integer.class);
        for (int i = 0; i < this.radioButtons.length; ++i) {
            JRadioButton radioButton = this.radioButtons[i];
            if (i != 0 && i != initIndex) continue;
            radioButton.setSelected(true);
        }
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.radioButtons != null && this.radioButtons.length > 0 && formEnvironment != null) {
            this.radioButtons[0].getParent().setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.buttonGroup = new ButtonGroup();
        String[] radioButtonLabels = this.getRadioButtonLabels();
        this.radioButtons = new JRadioButton[radioButtonLabels.length];
        RadioButtonPanelPanel panel = new RadioButtonPanelPanel(this.buttonGroup);
        panel.setName(this.getFormEnvironment().getId(this));
        int axis = this.getAxisType() == AxisType.HORIZONTAL ? 0 : 1;
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        for (int i = 0; i < radioButtonLabels.length; ++i) {
            JRadioButton radioButton = new JRadioButton(radioButtonLabels[i]);
            radioButton.addItemListener(e -> {
                if (this.getFormEnvironment().isInitialized() && e.getStateChange() == 1) {
                    this.executeSelectionScript();
                }
            });
            this.buttonGroup.add(radioButton);
            if (i == 0) {
                radioButton.setSelected(true);
            }
            radioButton.setActionCommand(String.valueOf(i));
            radioButton.setAlignmentX(0.0f);
            panel.add(radioButton);
            this.radioButtons[i] = radioButton;
        }
        return panel;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.buttonGroup;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return ButtonGroup.class;
    }

    @Override
    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), Integer.valueOf(this.buttonGroup.getSelection().getActionCommand()));
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    public void formActivated() {
        super.formActivated();
        SelectionScriptHolder.super.formActivated();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String[] descriptions = new String[this.buttonGroup.getButtonCount()];
        AbstractButton[] buttons = new AbstractButton[this.buttonGroup.getButtonCount()];
        int i = 0;
        Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button;
            buttons[i] = button = elements.nextElement();
            descriptions[i++] = button.getText();
        }
        int newValue = console.askOption(this.getConsoleLabelText(false), descriptions, null, Integer.parseInt(this.buttonGroup.getSelection().getActionCommand()));
        buttons[newValue].setSelected(true);
        this.executeSelectionScript();
        return true;
    }

    @Override
    public void executeSelectionScript() {
        try {
            this.getContext().runScript(this.getSelectionScript(), this, this.getFormEnvironment(), this.getSelectedButtonIndex());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    private int getSelectedButtonIndex() {
        int index = 0;
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton currentButton = buttons.nextElement();
            if (currentButton.isSelected()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static class RadioButtonPanelPanel
    extends JPanel {
        private ButtonGroup buttonGroup;

        public RadioButtonPanelPanel(ButtonGroup buttonGroup) {
            this.buttonGroup = buttonGroup;
        }

        @Override
        public void setOpaque(boolean opaque) {
            super.setOpaque(opaque);
            if (this.buttonGroup != null) {
                Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
                while (elements.hasMoreElements()) {
                    elements.nextElement().setOpaque(opaque);
                }
            }
        }
    }
}

