/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.TextComponentUtil;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class TextComponent
extends LeadingLabelComponent
implements TextComponentUtil.InputVerifierParameterProvider {
    private String variableName = "";
    private String initialText = "";
    private Font textFont;
    private FontType textFontType = FontType.DEFAULT;
    private FontStyle textFontStyle = FontStyle.UNCHANGED;
    private int textFontSizePercent = 100;
    private ScriptProperty keyValidator;
    private ScriptProperty keyListener;
    private ScriptProperty inputVerifier;
    private boolean checkIfEmpty;
    private JTextComponent textComponent;

    protected abstract JTextComponent createTextComponent();

    public String getVariableName() {
        return TextComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialText() {
        return TextComponent.replaceVariables(this.replaceFormVariables(this.initialText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
    }

    public Font getTextFont() {
        return this.replaceWithTextOverride("textFont", this.textFont, Font.class);
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public FontType getTextFontType() {
        return this.replaceWithTextOverride("textFontType", this.textFontType, FontType.class);
    }

    public void setTextFontType(FontType textFontType) {
        this.textFontType = textFontType;
    }

    public FontStyle getTextFontStyle() {
        return this.replaceWithTextOverride("textFontStyle", this.textFontStyle, FontStyle.class);
    }

    public void setTextFontStyle(FontStyle textFontStyle) {
        this.textFontStyle = textFontStyle;
    }

    public int getTextFontSizePercent() {
        return this.replaceWithTextOverride("textFontSizePercent", this.textFontSizePercent);
    }

    public void setTextFontSizePercent(int textFontSizePercent) {
        this.textFontSizePercent = textFontSizePercent;
    }

    public ScriptProperty getKeyValidator() {
        return this.replaceWithTextOverride("keyValidator", this.keyValidator, ScriptProperty.class);
    }

    public void setKeyValidator(ScriptProperty keyValidator) {
        this.keyValidator = keyValidator;
    }

    public ScriptProperty getKeyListener() {
        return this.replaceWithTextOverride("keyListener", this.keyListener, ScriptProperty.class);
    }

    public void setKeyListener(ScriptProperty keyListener) {
        this.keyListener = keyListener;
    }

    public ScriptProperty getInputVerifier() {
        return this.replaceWithTextOverride("inputVerifier", this.inputVerifier, ScriptProperty.class);
    }

    public void setInputVerifier(ScriptProperty inputVerifier) {
        this.inputVerifier = inputVerifier;
    }

    public boolean isCheckIfEmpty() {
        return this.replaceWithTextOverride("checkIfEmpty", this.checkIfEmpty);
    }

    public void setCheckIfEmpty(boolean checkIfEmpty) {
        this.checkIfEmpty = checkIfEmpty;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initText(this.textComponent);
    }

    protected void initText(JTextComponent textComponent) {
        Object initValue = this.getInitValue(this.getInitialText(), this.getVariableName(), Object.class);
        if (initValue != null) {
            textComponent.setText(initValue.toString());
            textComponent.setCaretPosition(0);
        }
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.textComponent != null && formEnvironment != null) {
            this.textComponent.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.textComponent = this.createTextComponent();
        this.textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                TextComponent.this.dispatchToKeyValidator(event);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                TextComponent.this.dispatchToKeyListener(event);
            }
        });
        TextComponentUtil.addInputVerifier(this, this.getInputVerifier(), this.textComponent, this);
        this.applyTextComponentProperties(this.textComponent);
        return this.textComponent;
    }

    @Override
    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.textComponent.getText()};
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    protected void applyTextComponentProperties(JTextComponent textComponent) {
        textComponent.setAlignmentX(0.0f);
        this.applyFont(this.getTextFont(), this.getTextFontType(), this.getTextFontStyle(), this.getTextFontSizePercent(), textComponent);
    }

    @Override
    public Object getConfigurationObject() {
        return this.textComponent;
    }

    @Override
    public boolean checkCompleted() {
        if (this.isCheckIfEmpty() && this.textComponent.isVisible() && this.textComponent.isEnabled() && this.getTextValue().isEmpty()) {
            this.getFormEnvironment().makeParentGroupVisible(this);
            this.textComponent.requestFocus();
            GUIHelper.showMessage(this.textComponent, Messages.getString(".TextfieldEmptyWarning"), 2);
            return false;
        }
        InputVerifier inputVerifier = this.textComponent.getInputVerifier();
        if (this.isVisible() && this.isEnabled() && inputVerifier != null && !inputVerifier.verify(this.textComponent)) {
            if (!InstallerUtil.isUnattended() && !InstallerUtil.isConsole()) {
                SwingUtilities.invokeLater(() -> {
                    this.getFormEnvironment().makeParentGroupVisible(this);
                    this.textComponent.requestFocus();
                });
            }
            return false;
        }
        String variableName = this.getVariableName();
        if (!variableName.isEmpty()) {
            this.getContext().setVariable(variableName, this.getValue());
            if (this.isRegisterResponseFileVariable()) {
                this.getContext().registerResponseFileVariable(variableName);
            }
        }
        return true;
    }

    protected boolean isRegisterResponseFileVariable() {
        return true;
    }

    protected Object getValue() {
        return this.getTextValue();
    }

    protected String getTextValue() {
        return this.textComponent.getText().trim();
    }

    protected void dispatchToKeyValidator(KeyEvent event) {
        if (this.getKeyValidator() != null) {
            try {
                Boolean result = (Boolean)this.getContext().runScript(this.getKeyValidator(), this, this.getFormEnvironment(), Character.valueOf(event.getKeyChar()), this.textComponent.getText(), this.textComponent.getCaretPosition());
                if (result != null && !result.booleanValue()) {
                    event.consume();
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        }
    }

    protected void dispatchToKeyListener(KeyEvent event) {
        if (this.getKeyListener() != null) {
            try {
                this.getContext().runScript(this.getKeyListener(), this, this.getFormEnvironment(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), this.textComponent.getText(), this.textComponent.getCaretPosition());
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        }
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JTextComponent textField = this.getTextComponent();
        InputVerifier inputVerifier = textField.getInputVerifier();
        String oldValue = textField.getText();
        do {
            textField.setText(oldValue);
            String labelText = this.getConsoleLabelText(false);
            String newValue = this.askString(console, oldValue, labelText);
            textField.setText(newValue);
        } while (inputVerifier != null && !inputVerifier.verify(textField));
        return true;
    }

    protected String askString(Console console, String oldValue, String labelText) throws UserCanceledException {
        return console.askString(labelText, oldValue);
    }
}

