/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.UiUtil;
import com.install4j.api.context.Context;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.formcomponents.CreateUserDialog;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.ObjectPicker;
import com.install4j.runtime.util.TextAndButtonPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class UserSelectorComponent
extends LeadingLabelComponent {
    private boolean showUsers = true;
    private boolean showGroups = false;
    private boolean showWellKnownPrincipals = false;
    private boolean multipleSelection = false;
    private boolean onlyLocal = false;
    private boolean showCreateButton = false;
    private String variableName = "";
    private String userCreatedVariableName = "";
    private String localGroupVariableName = "";
    private String groupCreatedVariableName = "";
    private String passwordFormComponentId = "";
    private JTextField txtUsers;
    private JButton btnBrowse;
    private JButton btnCreate;
    private String[] selectedSids;
    private List<WinUser.AddUserResult> createdUserResults = new ArrayList<WinUser.AddUserResult>();

    public boolean isShowUsers() {
        return this.replaceWithTextOverride("showUsers", this.showUsers);
    }

    public void setShowUsers(boolean showUsers) {
        this.showUsers = showUsers;
    }

    public boolean isShowGroups() {
        return this.replaceWithTextOverride("showGroups", this.showGroups);
    }

    public void setShowGroups(boolean showGroups) {
        this.showGroups = showGroups;
    }

    public boolean isShowWellKnownPrincipals() {
        return this.replaceWithTextOverride("showWellKnownPrincipals", this.showWellKnownPrincipals);
    }

    public void setShowWellKnownPrincipals(boolean showWellKnownPrincipals) {
        this.showWellKnownPrincipals = showWellKnownPrincipals;
    }

    public boolean isMultipleSelection() {
        return this.replaceWithTextOverride("multipleSelection", this.multipleSelection);
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public boolean isOnlyLocal() {
        return this.replaceWithTextOverride("onlyLocal", this.onlyLocal);
    }

    public void setOnlyLocal(boolean onlyLocal) {
        this.onlyLocal = onlyLocal;
    }

    public boolean isShowCreateButton() {
        return this.replaceWithTextOverride("showCreateButton", this.showCreateButton);
    }

    public void setShowCreateButton(boolean showCreateButton) {
        this.showCreateButton = showCreateButton;
    }

    public String getVariableName() {
        return UserSelectorComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getUserCreatedVariableName() {
        return UserSelectorComponent.replaceVariables(this.userCreatedVariableName);
    }

    public void setUserCreatedVariableName(String userCreatedVariableName) {
        this.userCreatedVariableName = userCreatedVariableName;
    }

    public String getLocalGroupVariableName() {
        return UserSelectorComponent.replaceVariables(this.localGroupVariableName);
    }

    public void setLocalGroupVariableName(String localGroupVariableName) {
        this.localGroupVariableName = localGroupVariableName;
    }

    public String getGroupCreatedVariableName() {
        return UserSelectorComponent.replaceVariables(this.groupCreatedVariableName);
    }

    public void setGroupCreatedVariableName(String groupCreatedVariableName) {
        this.groupCreatedVariableName = groupCreatedVariableName;
    }

    public String getPasswordFormComponentId() {
        return UserSelectorComponent.replaceVariables(this.passwordFormComponentId);
    }

    public void setPasswordFormComponentId(String passwordFormComponentId) {
        this.passwordFormComponentId = passwordFormComponentId;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.txtUsers != null && formEnvironment != null) {
            this.txtUsers.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.txtUsers = new JTextField();
        this.txtUsers.setEditable(false);
        this.btnBrowse = new JButton(Messages.getString(".ButtonBrowse"));
        this.btnBrowse.addActionListener(e -> this.doBrowse());
        TextAndButtonPanel panel = new TextAndButtonPanel(this.txtUsers, this.btnBrowse);
        if (this.isShowUsers() && this.isShowCreateButton()) {
            this.btnCreate = new JButton(Messages.getString(".ButtonCreateUser"));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.gridy = 0;
            gc.gridx = 2;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.insets.left = 5;
            panel.add((Component)this.btnCreate, gc);
            this.btnCreate.addActionListener(e -> this.doCreate());
            this.setMultipleSelection(false);
        }
        return panel;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isMultipleSelection()) {
            this.selectedSids = (String[])this.getInitValue(null, this.getVariableName(), String[].class);
        } else {
            String initialSid = (String)this.getInitValue(null, this.getVariableName(), String.class);
            if (initialSid != null) {
                this.selectedSids = new String[]{initialSid};
            }
        }
        this.updateTextField();
    }

    @Override
    public boolean checkCompleted() {
        String variableName = this.getVariableName();
        Object variableValue = this.getVariableValue();
        Context context = this.getContext();
        context.setVariable(variableName, variableValue);
        context.registerResponseFileVariable(variableName);
        if (this.isShowUsers() && this.isShowCreateButton()) {
            if (!this.getUserCreatedVariableName().isEmpty()) {
                context.setVariable(this.getUserCreatedVariableName(), Boolean.FALSE);
            }
            if (!this.getLocalGroupVariableName().isEmpty()) {
                context.setVariable(this.getLocalGroupVariableName(), "");
            }
            if (!this.getGroupCreatedVariableName().isEmpty()) {
                context.setVariable(this.getGroupCreatedVariableName(), Boolean.FALSE);
            }
            String userSid = (String)variableValue;
            Iterator<WinUser.AddUserResult> iterator = this.createdUserResults.iterator();
            while (iterator.hasNext()) {
                WinUser.AddUserResult userResult = iterator.next();
                if (Objects.equals(userResult.getUserSid(), userSid)) {
                    if (!this.getUserCreatedVariableName().isEmpty()) {
                        context.setVariable(this.getUserCreatedVariableName(), Boolean.TRUE);
                        context.registerResponseFileVariable(this.getUserCreatedVariableName());
                    }
                    if (!this.getLocalGroupVariableName().isEmpty() && userResult.getGroupSid() != null) {
                        context.setVariable(this.getLocalGroupVariableName(), userResult.getGroupSid());
                        context.registerResponseFileVariable(this.getLocalGroupVariableName());
                    }
                    if (this.getGroupCreatedVariableName().isEmpty()) continue;
                    context.setVariable(this.getGroupCreatedVariableName(), userResult.isGroupCreated());
                    context.registerResponseFileVariable(this.getGroupCreatedVariableName());
                    continue;
                }
                WinUser.deleteUser(userResult.getUserSid());
                if (userResult.isGroupCreated() && userResult.getGroupSid() != null) {
                    WinUser.deleteLocalGroup(userResult.getGroupSid());
                }
                iterator.remove();
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnBrowse.setEnabled(enabled);
        if (this.btnCreate != null) {
            this.btnCreate.setEnabled(enabled);
        }
    }

    private Object getVariableValue() {
        if (this.isMultipleSelection()) {
            if (this.selectedSids == null) {
                return new String[0];
            }
            return this.selectedSids;
        }
        if (this.selectedSids == null || this.selectedSids.length != 1) {
            return "";
        }
        return this.selectedSids[0];
    }

    private void doBrowse() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        ObjectPicker.Result[] results = ObjectPicker.show(this.isMultipleSelection(), this.isShowGroups(), this.isShowUsers(), this.isShowWellKnownPrincipals(), this.isOnlyLocal());
        if (results != null) {
            this.selectedSids = new String[results.length];
            for (int i = 0; i < results.length; ++i) {
                ObjectPicker.Result result = results[i];
                this.selectedSids[i] = result.getSid();
            }
            this.updateTextField();
        }
    }

    private void updateTextField() {
        if (this.selectedSids != null) {
            StringBuilder buffer = new StringBuilder();
            for (String selectedSid : this.selectedSids) {
                String accountName;
                if (buffer.length() > 0) {
                    buffer.append("; ");
                }
                if ((accountName = WinUser.getAccountName(selectedSid)) == null) continue;
                buffer.append(accountName);
            }
            this.txtUsers.setText(buffer.toString());
        }
    }

    private void doCreate() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        CreateUserDialog dialog = new CreateUserDialog(UiUtil.getParentWindow());
        dialog.setVisible(true);
        dialog.dispose();
        if (!dialog.isCanceled()) {
            String sid = dialog.getResult().getUserSid();
            this.selectedSids = new String[]{sid};
            this.txtUsers.setText(WinUser.getAccountName(sid));
            this.createdUserResults.add(dialog.getResult());
            if (!this.getPasswordFormComponentId().isEmpty()) {
                FormComponent passwordFormComponent = this.getFormEnvironment().getFormComponentById(this.getPasswordFormComponentId());
                if (passwordFormComponent instanceof TextfieldComponent) {
                    ((JTextField)passwordFormComponent.getConfigurationObject()).setText(dialog.getPassword());
                } else {
                    Logger.getInstance().log(this, "The password form component with ID " + this.getPasswordFormComponentId() + " is not a text field form component.", false);
                }
            }
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }
}

