/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.beans.screens.componentselection.DescriptionModeProvider;
import com.install4j.runtime.beans.screens.installationtype.ComponentsSelectionType;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeTree;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstallationTypeScreen
extends SystemScreen
implements DescriptionModeProvider {
    public static final String VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION = "sys.preventComponentCustomization";
    private boolean activated;
    private InstallationTypeTree tree;
    private JScrollPane scpTree;
    private List<InstallationTypeConfig> installationTypeConfigs = new ArrayList<InstallationTypeConfig>();
    private String initialId = null;
    private Boolean overridePreventComponentCustomization;
    private boolean boldDescription = false;
    private boolean italicDescription = false;
    private boolean smallerDescription = false;

    public List<InstallationTypeConfig> getInstallationTypeConfigs() {
        return this.replaceWithTextOverride("installationTypeConfigs", this.installationTypeConfigs, List.class);
    }

    public void setInstallationTypeConfigs(List<InstallationTypeConfig> installationTypeConfigs) {
        this.installationTypeConfigs = installationTypeConfigs;
    }

    @Override
    public boolean isBoldDescription() {
        return this.replaceWithTextOverride("boldDescription", this.boldDescription);
    }

    public void setBoldDescription(boolean boldDescription) {
        this.boldDescription = boldDescription;
    }

    @Override
    public boolean isItalicDescription() {
        return this.replaceWithTextOverride("italicDescription", this.italicDescription);
    }

    public void setItalicDescription(boolean italicDescription) {
        this.italicDescription = italicDescription;
    }

    @Override
    public boolean isSmallerDescription() {
        return this.replaceWithTextOverride("smallerDescription", this.smallerDescription);
    }

    public void setSmallerDescription(boolean smallerDescription) {
        this.smallerDescription = smallerDescription;
    }

    @Override
    public String getTitle() {
        return this.getMessage(".WizardInstallationType");
    }

    @Override
    public String getSubTitle() {
        return this.getMessage(".SelectInstallationType");
    }

    public String getInitialId() {
        return this.initialId;
    }

    @Override
    public boolean next() {
        this.applySelectedConfig(this.tree.getSelectedConfig());
        return true;
    }

    private void applySelectedConfig(InstallationTypeConfig selectedConfig) {
        if (!(selectedConfig == null || selectedConfig.isUserCanCustomize() && selectedConfig.getId().equals(this.getInitialId()))) {
            for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(false);
            }
            for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(this.isSelectedComponent(componentConfig, selectedConfig));
            }
        }
    }

    private boolean isSelectedComponent(ComponentConfig componentConfig, InstallationTypeConfig selectedConfig) {
        ComponentsSelectionType componentsSelectionType = selectedConfig.getComponentsSelectionType();
        if (componentsSelectionType == ComponentsSelectionType.ALL) {
            return true;
        }
        if (componentsSelectionType == ComponentsSelectionType.DEFAULT) {
            return componentConfig.isInitiallySelected();
        }
        String targetId = componentConfig.getId();
        for (String componentId : selectedConfig.getSelectedComponentIds()) {
            ComponentNodeConfig selectedComponentConfig = InstallerConfig.getCurrentInstance().getComponentNodeById(componentId);
            if (selectedComponentConfig == null || !(selectedComponentConfig instanceof ComponentFolderConfig ? this.isContainedInFolder((ComponentFolderConfig)selectedComponentConfig, targetId) : Objects.equals(selectedComponentConfig.getId(), targetId))) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInFolder(ComponentFolderConfig componentFolderConfig, String id) {
        for (ComponentNodeConfig componentNodeConfig : componentFolderConfig.getComponents()) {
            boolean found;
            if (!(componentNodeConfig instanceof ComponentFolderConfig ? (found = this.isContainedInFolder((ComponentFolderConfig)componentNodeConfig, id)) : Objects.equals(componentNodeConfig.getId(), id))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        String headerMessage = this.getMessage(".SelectInstallationTypeLabel");
        if (!headerMessage.trim().isEmpty()) {
            this.addDisplayTextArea(headerMessage, panel, gc);
            gc.insets.top = 5;
        }
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        panel.add((Component)this.scpTree, gc);
        ++gc.gridy;
    }

    @Override
    public void setInstallerContext(InstallerContext context) {
        super.setInstallerContext(context);
        InstallerVariables.registerResponseFileVariable("sys.installationTypeId");
        Object varValue = InstallerVariables.getVariable("sys.installationTypeId");
        if (varValue instanceof String) {
            this.initialId = (String)varValue;
        }
        InstallerVariables.registerVariableProvider("sys.installationTypeId", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                return InstallationTypeScreen.this.tree == null ? InstallationTypeScreen.this.initialId : InstallationTypeScreen.this.tree.getSelectedId();
            }

            @Override
            public void setVariable(Object value) {
                if (value instanceof String) {
                    String id = (String)value;
                    if (InstallationTypeScreen.this.tree == null) {
                        InstallationTypeScreen.this.initialId = id;
                    } else {
                        InstallationTypeScreen.this.tree.setSelectedId(id);
                        if (!InstallationTypeScreen.this.activated && InstallationTypeScreen.this.initialId == null) {
                            InstallationTypeScreen.this.initialId = id;
                        }
                    }
                }
            }
        });
        InstallerVariables.registerVariableProvider(VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION, new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                if (InstallationTypeScreen.this.overridePreventComponentCustomization != null) {
                    return InstallationTypeScreen.this.overridePreventComponentCustomization;
                }
                if (InstallationTypeScreen.this.tree == null) {
                    return Boolean.FALSE;
                }
                InstallationTypeConfig selectedConfig = InstallationTypeScreen.this.tree.getSelectedConfig();
                if (selectedConfig == null) {
                    return Boolean.FALSE;
                }
                return selectedConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public void setVariable(Object value) {
            }
        });
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationTypeTree(this);
        this.scpTree = new JScrollPane(this.tree);
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        int typeCount = this.getInstallationTypeConfigs().size();
        String[] keys = new String[typeCount];
        String[] descriptions = new String[typeCount];
        String[] helpTexts = new String[typeCount];
        int defaultValue = 0;
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = String.valueOf(i + 1);
            InstallationTypeConfig config = this.getInstallationTypeConfigs().get(i);
            descriptions[i] = config.getName();
            helpTexts[i] = config.getDescription();
            if (!config.getId().equals(this.initialId) && !config.getDisplayedId().equals(this.initialId)) continue;
            defaultValue = i;
        }
        int result = console.askOption(this.getMessage(".SelectInstallationType"), descriptions, keys, helpTexts, defaultValue, false, true);
        if (result > -1) {
            InstallationTypeConfig selectedConfig = this.getInstallationTypeConfigs().get(result);
            this.tree.setSelectedId(selectedConfig.getId());
            this.overridePreventComponentCustomization = selectedConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            this.applySelectedConfig(selectedConfig);
            this.initialId = selectedConfig.getDisplayedId();
        }
        return true;
    }

    @Override
    public void willActivate() {
        this.activated = true;
        super.willActivate();
    }
}

