/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.CharBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.CharToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharBooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.CharBooleanMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableCharBooleanMap;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharBooleanPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharBooleanMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableBooleanValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableCharKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedCharBooleanMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableCharBooleanMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class CharBooleanHashMap
extends AbstractMutableBooleanValuesMap
implements MutableCharBooleanMap,
MutableCharKeysMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private char[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableBooleanValuesMap.SentinelValues sentinelValues;

    public CharBooleanHashMap() {
        this.allocateTable(16);
    }

    public CharBooleanHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public CharBooleanHashMap(CharBooleanMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    @Deprecated
    public CharBooleanHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity);
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected boolean getEmptyValue() {
        return false;
    }

    @Override
    protected int getTableSize() {
        return this.keys.length;
    }

    @Override
    protected boolean getValueAtIndex(int index) {
        return this.values.get(index);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !CharBooleanHashMap.isEmptyKey(this.keys[index]) && !CharBooleanHashMap.isRemovedKey(this.keys[index]);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public MutableCharBooleanMap asUnmodifiable() {
        return new UnmodifiableCharBooleanMap(this);
    }

    public MutableCharBooleanMap asSynchronized() {
        return new SynchronizedCharBooleanMap(this);
    }

    public ImmutableCharBooleanMap toImmutable() {
        return CharBooleanMaps.immutable.withAll((CharBooleanMap)this);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1) {
        return new CharBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2) {
        return new CharBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3) {
        return new CharBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3, char key4, boolean value4) {
        return new CharBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public CharBooleanHashMap withKeyValue(char key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3, char key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharBooleanHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharBooleanHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharBooleanHashMap.isEmptyKey(key) && !CharBooleanHashMap.isRemovedKey(key);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    public boolean trimToSize() {
        int newCapacity = this.smallestPowerOfTwoGreaterThan(this.size());
        if (this.keys.length > newCapacity) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Deprecated
    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(char element) {
        int index = this.spreadAndMask(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            char keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = Integer.reverse(SpreadFunctions.charSpreadOne(element));
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        this.values.clear();
    }

    public void put(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.getSentinelValues() == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsZeroKey = true;
            this.getSentinelValues().zeroValue = value;
            return;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsOneKey = true;
            this.getSentinelValues().oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(CharBooleanMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(CharBooleanToBooleanFunction function) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf('\u0000', this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf('\u0001', this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            this.values.set(i, function.valueOf(this.keys[i], this.getValueAtIndex(i)));
        }
    }

    @Override
    public boolean containsKey(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsZeroKey;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean get(char key) {
        return this.getIfAbsent(key, this.getEmptyValue());
    }

    public boolean getIfAbsent(char key, boolean ifAbsent) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPut(char key, BooleanFunction0 function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(char key, BooleanFunction<? super P> function, P parameter) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPutWithKey(char key, CharToBooleanFunction function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean updateValue(char key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf(this.getSentinelValues().zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf(this.getSentinelValues().oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(char key, boolean value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public void removeKey(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            boolean oldValue = this.values.get(index);
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharBooleanMap)) {
            return false;
        }
        CharBooleanMap other = (CharBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.getSentinelValues().containsZeroKey && (!other.containsKey('\u0000') || this.getSentinelValues().zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && (!other.containsKey('\u0001') || this.getSentinelValues().oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i) || other.containsKey(this.keys[i]) && this.getValueAtIndex(i) == other.getOrThrow(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0 ^ (this.getSentinelValues().zeroValue ? 1231 : 1237);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += 1 ^ (this.getSentinelValues().oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.getValueAtIndex(i) ? 1231 : 1237);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                appendable.append('\u0000').append("=").append(this.getSentinelValues().zeroValue);
                first = false;
            }
            if (this.getSentinelValues().containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(this.getSentinelValues().oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.keys[i]).append("=").append(this.getValueAtIndex(i));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableBooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (char key : this.keys) {
            if (!CharBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(CharBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value('\u0000', this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value('\u0001', this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.getValueAtIndex(i));
        }
    }

    public CharBooleanHashMap select(CharBooleanPredicate predicate) {
        CharBooleanHashMap result = new CharBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000', this.getSentinelValues().zeroValue)) {
                result.put('\u0000', this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001', this.getSentinelValues().oneValue)) {
                result.put('\u0001', this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public CharBooleanHashMap reject(CharBooleanPredicate predicate) {
        CharBooleanHashMap result = new CharBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept('\u0000', this.getSentinelValues().zeroValue)) {
                result.put('\u0000', this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept('\u0001', this.getSentinelValues().oneValue)) {
                result.put('\u0001', this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(0.5f);
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                out.writeChar(0);
                out.writeBoolean(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                out.writeChar(1);
                out.writeBoolean(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeBoolean(this.getValueAtIndex(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        in.readFloat();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readBoolean());
        }
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$302(CharBooleanHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<CharBooleanPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super CharBooleanPair> procedure) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.getSentinelValues().zeroValue));
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.getSentinelValues().oneValue));
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.getValueAtIndex(i)));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharBooleanPair> objectIntProcedure) {
            int index = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.getSentinelValues().zeroValue), index);
                    ++index;
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.getSentinelValues().oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.getValueAtIndex(i)), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharBooleanPair, ? super P> procedure, P parameter) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.getSentinelValues().zeroValue), parameter);
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.getSentinelValues().oneValue), parameter);
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.getValueAtIndex(i)), parameter);
            }
        }

        public Iterator<CharBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<CharBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharBooleanHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.getSentinelValues().zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharBooleanHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.getSentinelValues().oneValue);
                    }
                }
                char[] keys = CharBooleanHashMap.this.keys;
                while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharBooleanPair result = PrimitiveTuples.pair(keys[this.position], CharBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean removed = true;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharBooleanHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.removed = false;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharBooleanHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharBooleanHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys = CharBooleanHashMap.this.keys;
            while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            CharBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.removed = true;
        }
    }

    private class ValuesCollection
    extends AbstractMutableBooleanValuesMap.AbstractBooleanValuesCollection {
        private ValuesCollection() {
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharBooleanHashMap.this.sentinelValues != null) {
                    if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf(CharBooleanHashMap.this.getSentinelValues().zeroValue));
                        first = false;
                    }
                    if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(CharBooleanHashMap.this.getSentinelValues().oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                    if (!CharBooleanHashMap.this.isNonSentinelAtIndex(i)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(CharBooleanHashMap.this.getValueAtIndex(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public MutableBooleanIterator booleanIterator() {
            return CharBooleanHashMap.this.booleanIterator();
        }

        public boolean remove(boolean item) {
            int oldSize = CharBooleanHashMap.this.size();
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey && item == CharBooleanHashMap.this.getSentinelValues().zeroValue) {
                    CharBooleanHashMap.this.removeKey('\u0000');
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey && item == CharBooleanHashMap.this.getSentinelValues().oneValue) {
                    CharBooleanHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i]) || item != CharBooleanHashMap.this.getValueAtIndex(i)) continue;
                CharBooleanHashMap.this.removeKey(CharBooleanHashMap.this.keys[i]);
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            CharBooleanHashMap retained = CharBooleanHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$9f7006ea$1((BooleanSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                CharBooleanHashMap.access$302(CharBooleanHashMap.this, retained.keys);
                CharBooleanHashMap.this.values = retained.values;
                CharBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                CharBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$retainAll$9f7006ea$1(BooleanSet sourceSet, char key, boolean value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableCharKeySet {
        private KeySet() {
        }

        @Override
        protected char getKeyAtIndex(int index) {
            return CharBooleanHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return CharBooleanHashMap.this.keys.length;
        }

        @Override
        protected MutableCharKeysMap getOuter() {
            return CharBooleanHashMap.this;
        }

        @Override
        protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
            return CharBooleanHashMap.this.sentinelValues;
        }

        public MutableCharIterator charIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharBooleanHashMap retained = CharBooleanHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$91bd0fea$1((CharSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                CharBooleanHashMap.access$302(CharBooleanHashMap.this, retained.keys);
                CharBooleanHashMap.this.values = retained.values;
                CharBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                CharBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public MutableCharSet newEmpty() {
            return new CharHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$91bd0fea$1(CharSet sourceSet, char key, boolean value) {
            return sourceSet.contains(key);
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        @Override
        public boolean isEmpty() {
            return CharBooleanHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return CharBooleanHashMap.this.notEmpty();
        }

        @Override
        public int size() {
            return CharBooleanHashMap.this.size();
        }

        @Override
        public boolean contains(char key) {
            return CharBooleanHashMap.this.containsKey(key);
        }

        @Override
        public boolean containsAll(char ... keys) {
            for (char key : keys) {
                if (CharBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(CharIterable source) {
            return source.allSatisfy(CharBooleanHashMap.this::containsKey);
        }

        public CharIterator charIterator() {
            return new UnmodifiableCharIterator((CharIterator)new KeySetIterator());
        }

        public void each(CharProcedure procedure) {
            CharBooleanHashMap.this.forEachKey(procedure);
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharBooleanHashMap.this.sentinelValues != null) {
                    if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharBooleanHashMap.this.keys) {
                    if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public char detectIfNone(CharPredicate predicate, char value) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        @Override
        public long sum() {
            long result = 0L;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result += 0L;
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    ++result;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        @Override
        public char max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char max = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        @Override
        public char min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char min = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        @Override
        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        @Override
        public char[] toArray() {
            int size = CharBooleanHashMap.this.size();
            final char[] result = new char[size];
            CharBooleanHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, CharBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        @Override
        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        @Override
        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        @Override
        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }
    }

    private class InternalBooleanIterator
    implements MutableBooleanIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < CharBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharBooleanHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return CharBooleanHashMap.this.getSentinelValues().zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharBooleanHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return CharBooleanHashMap.this.getSentinelValues().oneValue;
                }
            }
            char[] keys = CharBooleanHashMap.this.keys;
            while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            boolean result = CharBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

