/*
 * Decompiled with CFR 0.152.
 */
package org.cisecurity.license;

import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.security.SignatureException;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.util.Base64;
import java.util.Map;
import org.cisecurity.assessor.util.AssessorUtilities;
import org.cisecurity.util.Now;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.LoggerFactory;

public class OfflineLicenseValidator
implements GroovyObject {
    private Object log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public OfflineLicenseValidator() {
        MetaClass metaClass;
        Object object;
        CallSite[] callSiteArray = OfflineLicenseValidator.$getCallSiteArray();
        this.log = object = callSiteArray[0].call(LoggerFactory.class, OfflineLicenseValidator.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        CallSite[] callSiteArray = OfflineLicenseValidator.$getCallSiteArray();
        int bufLen = 1024;
        byte[] buf = new byte[bufLen];
        int readLen = 0;
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class);
        while (true) {
            Object object = callSiteArray[2].call((Object)inputStream, (Object)buf, (Object)0, (Object)bufLen);
            readLen = DefaultTypeTransformation.intUnbox((Object)object);
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)object, (Object)-1)) break;
            callSiteArray[3].call((Object)outputStream, (Object)buf, (Object)0, (Object)readLen);
        }
        byte[] byArray = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)outputStream), byte[].class);
        try {
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray2 = (byte[])ScriptBytecodeAdapter.castToType(null, byte[].class);
            return byArray2;
        }
    }

    public Object validate(Object uuidAndLicenseKey) {
        CallSite[] callSiteArray = OfflineLicenseValidator.$getCallSiteArray();
        callSiteArray[5].call(this.log, (Object)"[START] Offline License Validation");
        Object uuid = callSiteArray[6].call(uuidAndLicenseKey, (Object)"UUID");
        Object licenseKey = callSiteArray[7].call(uuidAndLicenseKey, (Object)"license_key");
        Object noLicense = callSiteArray[8].call(uuidAndLicenseKey, (Object)"no_license_key");
        Object version = callSiteArray[9].call(uuidAndLicenseKey, (Object)"version");
        PublicKey publicKey = null;
        callSiteArray[10].call(this.log, (Object)"[START] Offline License Verification");
        if (DefaultTypeTransformation.booleanUnbox((Object)noLicense)) {
            callSiteArray[11].call(this.log, (Object)new GStringImpl(new Object[]{noLicense}, new String[]{" - NO LICENSE: ", ""}));
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"UUID", "N/A", "license-key-valid", "false", "error-message", "No license provided; Please Download a new license from WorkBench, and ensure it is saved in the correct location."});
        }
        callSiteArray[12].call(this.log, (Object)new GStringImpl(new Object[]{uuid}, new String[]{" - UUID: ", ""}));
        callSiteArray[13].call(this.log, (Object)new GStringImpl(new Object[]{licenseKey}, new String[]{" -  KEY: \n", ""}));
        LocalDate today = (LocalDate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty(Now.class)), LocalDate.class);
        LocalDate cutoffDate = (LocalDate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(LocalDate.class, (Object)"2024-04-01"), LocalDate.class);
        Object object = callSiteArray[17].call(Boolean.class, callSiteArray[18].call(callSiteArray[19].callGetProperty(AssessorUtilities.class), (Object)"ciscat.license.allow.previous"));
        Object allowPrevious = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Boolean.valueOf(false);
        if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"1") && DefaultTypeTransformation.booleanUnbox((Object)allowPrevious)) {
            PublicKey publicKey2;
            ObjectInputStream inputStream = (ObjectInputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(ObjectInputStream.class, callSiteArray[21].call(callSiteArray[22].callCurrent((GroovyObject)this), (Object)"/license/license-verification.key")), ObjectInputStream.class);
            publicKey = publicKey2 = (PublicKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)inputStream), PublicKey.class);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"2")) {
            byte[] keyBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callStatic(OfflineLicenseValidator.class, callSiteArray[25].call(callSiteArray[26].callCurrent((GroovyObject)this), (Object)"/license/license-verification-2.key")), byte[].class);
            if (ScriptBytecodeAdapter.compareEqual((Object)keyBytes, null)) {
                callSiteArray[27].call(this.log, (Object)" - ERROR reading public key");
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"UUID", "N/A", "license-key-valid", "false", "error-message", "No license provided; Please Download a license from WorkBench"});
            }
            String key = ShortTypeHandling.castToString((Object)callSiteArray[28].callConstructor(String.class, (Object)keyBytes));
            String begin = "-----BEGIN PUBLIC KEY-----";
            String end = "-----END PUBLIC KEY-----";
            Object object2 = callSiteArray[29].call((Object)key, (Object)begin, (Object)"");
            key = ShortTypeHandling.castToString((Object)object2);
            Object object3 = callSiteArray[30].call((Object)key, (Object)end, (Object)"");
            key = ShortTypeHandling.castToString((Object)object3);
            Object object4 = callSiteArray[31].call(callSiteArray[32].call((Object)key, (Object)"\n", (Object)""), (Object)"\r", (Object)"");
            key = ShortTypeHandling.castToString((Object)object4);
            byte[] byteKey = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(callSiteArray[34].call(Base64.class), callSiteArray[35].call((Object)key)), byte[].class);
            X509EncodedKeySpec X509publicKey = (X509EncodedKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callConstructor(X509EncodedKeySpec.class, (Object)byteKey), X509EncodedKeySpec.class);
            KeyFactory kf = (KeyFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call(KeyFactory.class, (Object)"RSA"), KeyFactory.class);
            Object object5 = callSiteArray[38].call((Object)kf, (Object)X509publicKey);
            publicKey = (PublicKey)ScriptBytecodeAdapter.castToType((Object)object5, PublicKey.class);
        } else {
            callSiteArray[39].call(this.log, (Object)" - ERROR License version invalid");
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"UUID", "N/A", "license-key-valid", "false", "error-message", "License version is invalid; Please Download a new license from WorkBench."});
        }
        BufferedReader br = (BufferedReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(BufferedReader.class, callSiteArray[41].callConstructor(StringReader.class, licenseKey)), BufferedReader.class);
        public final class _validate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validate_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object result, Object entry) {
                CallSite[] callSiteArray = _validate_closure1.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].call(callSiteArray[1].call(entry)), (Object)0)) {
                    return callSiteArray[2].call(result, callSiteArray[3].call(entry));
                }
                return result;
            }

            @Generated
            public Object call(Object result, Object entry) {
                CallSite[] callSiteArray = _validate_closure1.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, result, entry);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "length";
                stringArray[1] = "trim";
                stringArray[2] = "leftShift";
                stringArray[3] = "trim";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _validate_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object licenseKeyLines = callSiteArray[42].call(callSiteArray[43].call((Object)br), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)new _validate_closure1(this, this));
        Object licenseKeyEncoded = "";
        if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"1")) {
            Object object6;
            licenseKeyEncoded = object6 = callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(licenseKeyLines, (Object)1), (Object)1));
        } else if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"2")) {
            Object object7;
            Object object8;
            Object object9;
            String start = "--- START CIS LICENSE KEY ---";
            String end = "--- END CIS LICENSE KEY ---";
            licenseKeyEncoded = object9 = callSiteArray[47].call(licenseKey, (Object)start, (Object)"");
            licenseKeyEncoded = object8 = callSiteArray[48].call(licenseKeyEncoded, (Object)end, (Object)"");
            licenseKeyEncoded = object7 = callSiteArray[49].call(licenseKeyEncoded);
        }
        Map rez = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"UUID", uuid, "license-key-valid", "true"});
        try {
            Jws claimsJws = null;
            if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object10 = callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(Jwts.class), (Object)publicKey), (Object)"CIS LICENSE KEY"), callSiteArray[56].call(callSiteArray[57].call((Object)60, (Object)60), (Object)24))), licenseKeyEncoded);
                claimsJws = (Jws)ScriptBytecodeAdapter.castToType((Object)object10, Jws.class);
            } else {
                Object object11 = callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(Jwts.class), (Object)publicKey), (Object)"CIS LICENSE KEY"), (Object)(60 * 60 * 24))), licenseKeyEncoded);
                claimsJws = (Jws)ScriptBytecodeAdapter.castToType((Object)object11, Jws.class);
            }
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"2") && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call((Object)claimsJws), (Object)"capabilities"), (Object)"CIS-CAT Pro Assessor"))) {
                    String string = "false";
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
                    String string2 = "License is not valid for CIS-CAT Pro Assessor or Dashboard.";
                    ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)rez, (String)"error-message");
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"2") && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].call(callSiteArray[68].call(callSiteArray[69].call((Object)claimsJws), (Object)"capabilities"), (Object)"CIS-CAT Pro Assessor"))) {
                String string = "false";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
                String string3 = "License is not valid for CIS-CAT Pro Assessor or Dashboard.";
                ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)rez, (String)"error-message");
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[70].call(callSiteArray[71].callGetProperty((Object)claimsJws)), (Object)uuid)) {
                String string = "false";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
                String string4 = "Invalid License. Please Download a valid license from WorkBench";
                ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)rez, (String)"error-message");
            }
        }
        catch (SignatureException e) {
            String string = "false";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
            String string5 = "Invalid License. Please Download a valid license from WorkBench";
            ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)rez, (String)"error-message");
            callSiteArray[72].call(this.log, (Object)new GStringImpl(new Object[]{callSiteArray[73].callGetProperty((Object)e)}, new String[]{"Invalid Signature: ", ""}));
        }
        catch (ExpiredJwtException exp) {
            String string = "false";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
            String string6 = "License Expired; Please Download a new license from WorkBench.";
            ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)rez, (String)"error-message");
            callSiteArray[74].call(this.log, (Object)new GStringImpl(new Object[]{callSiteArray[75].callGetProperty((Object)exp)}, new String[]{"License Expired: ", ""}));
        }
        catch (MalformedJwtException mje) {
            String string = "false";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)rez, (String)"license-key-valid");
            String string7 = "Invalid License. Please Download a valid license from WorkBench";
            ScriptBytecodeAdapter.setProperty((Object)string7, null, (Object)rez, (String)"error-message");
            callSiteArray[76].call(this.log, (Object)new GStringImpl(new Object[]{callSiteArray[77].callGetProperty((Object)mje)}, new String[]{"Invalid Token: ", ""}));
        }
        callSiteArray[78].call(this.log, callSiteArray[79].call(JsonOutput.class, (Object)rez));
        callSiteArray[80].call(this.log, (Object)"[ END ] Offline License Validation");
        return rez;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OfflineLicenseValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public Object getLog() {
        return this.log;
    }

    @Generated
    public void setLog(Object object) {
        this.log = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "read";
        stringArray[3] = "write";
        stringArray[4] = "toByteArray";
        stringArray[5] = "info";
        stringArray[6] = "getAt";
        stringArray[7] = "getAt";
        stringArray[8] = "getAt";
        stringArray[9] = "getAt";
        stringArray[10] = "info";
        stringArray[11] = "info";
        stringArray[12] = "info";
        stringArray[13] = "debug";
        stringArray[14] = "date";
        stringArray[15] = "instance";
        stringArray[16] = "parse";
        stringArray[17] = "parseBoolean";
        stringArray[18] = "getUserProperty";
        stringArray[19] = "instance";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "getResourceAsStream";
        stringArray[22] = "getClass";
        stringArray[23] = "readObject";
        stringArray[24] = "readAllBytes";
        stringArray[25] = "getResourceAsStream";
        stringArray[26] = "getClass";
        stringArray[27] = "info";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "replaceAll";
        stringArray[30] = "replaceAll";
        stringArray[31] = "replaceAll";
        stringArray[32] = "replaceAll";
        stringArray[33] = "decode";
        stringArray[34] = "getDecoder";
        stringArray[35] = "getBytes";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "getInstance";
        stringArray[38] = "generatePublic";
        stringArray[39] = "info";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "inject";
        stringArray[43] = "readLines";
        stringArray[44] = "join";
        stringArray[45] = "drop";
        stringArray[46] = "dropRight";
        stringArray[47] = "replaceAll";
        stringArray[48] = "replaceAll";
        stringArray[49] = "trim";
        stringArray[50] = "parseSignedClaims";
        stringArray[51] = "build";
        stringArray[52] = "clockSkewSeconds";
        stringArray[53] = "requireSubject";
        stringArray[54] = "verifyWith";
        stringArray[55] = "parser";
        stringArray[56] = "multiply";
        stringArray[57] = "multiply";
        stringArray[58] = "parseSignedClaims";
        stringArray[59] = "build";
        stringArray[60] = "clockSkewSeconds";
        stringArray[61] = "requireSubject";
        stringArray[62] = "verifyWith";
        stringArray[63] = "parser";
        stringArray[64] = "contains";
        stringArray[65] = "get";
        stringArray[66] = "getPayload";
        stringArray[67] = "contains";
        stringArray[68] = "get";
        stringArray[69] = "getPayload";
        stringArray[70] = "getId";
        stringArray[71] = "body";
        stringArray[72] = "info";
        stringArray[73] = "localizedMessage";
        stringArray[74] = "info";
        stringArray[75] = "localizedMessage";
        stringArray[76] = "info";
        stringArray[77] = "localizedMessage";
        stringArray[78] = "info";
        stringArray[79] = "toJson";
        stringArray[80] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[81];
        OfflineLicenseValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OfflineLicenseValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OfflineLicenseValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

