<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" 
    xmlns:windows-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix" 
    xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:fn="stylesheet-function" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
    xmlns:cce="http://benchmarks.cisecurity.org/cce/1.0" xmlns:cve="http://benchmarks.cisecurity.org/cve/1.1" xmlns:scap-core="http://scap.nist.gov/schema/scap-core/0.3"
    xmlns:xhtml="http://www.w3.org/1999/xhtml" version="3.0" exclude-result-prefixes="xs oval oval-def oval-res oval-sc ind-def windows-def unix-def linux-def">
    
    <xsl:strip-space elements="*"/>
    
    <xsl:output method="xhtml" encoding="UTF-8" xmlns="http://www.w3.org/1999/xhtml" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" omit-xml-declaration="yes" indent="yes"/>
    <xsl:output name="serialize" method="xml" omit-xml-declaration="yes" indent="yes" exclude-result-prefixes="#all"/>
    
    <xsl:character-map name="as-is">
        <xsl:output-character character="&lt;" string="&lt;"/>
        <xsl:output-character character="&gt;" string="&gt;"/>
        <xsl:output-character character="&amp;" string="&amp;"/>
        <xsl:output-character character="&apos;" string="&apos;"/>
        <xsl:output-character character="&quot;" string="&quot;"/>
    </xsl:character-map>
    
    <!-- *********** START: Stylesheet Parameters *************** -->
    <xsl:param name="debugging" as="xs:boolean" required="no" select="false()"/>
    <xsl:param name="includeFailures" as="xs:boolean" required="no" select="false()"/>
    
    <xsl:param name="cover_page_url" as="xs:string"/>
    <xsl:param name="logo_url" as="xs:string"/>
    <xsl:param name="cover_page_subtitle_url" as="xs:string"/>
    <xsl:param name="include_default_coverpage_footer" as="xs:boolean" select="true()"/>
    <xsl:param name="cover_page_footer_url" as="xs:string" select="'DEFAULT'"/>
    <xsl:param name="css_content" as="xs:string"/>
    
    <!-- *********** START: Functions *************** -->
    <xsl:function name="fn:isDisplayed" as="xs:boolean">
        <xsl:param name="result"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="display" as="xs:boolean">
            <xsl:choose>
                <xsl:when test="$class = 'vulnerability' and $result = 'true'">true</xsl:when>  <!-- Display vulnerabilities -->
                <xsl:when test="$class = 'patch'         and $result = 'true'">true</xsl:when>  <!-- Display un-patched items -->
                <xsl:when test="$class = 'compliance'    and $result = 'false'">true</xsl:when> <!-- Display compliance failures -->
                <xsl:when test="$class = 'inventory'     and $result = 'true'">true</xsl:when>  <!-- Display the stuff installed on the target -->
                <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="$display"/>
    </xsl:function>
    
    <xsl:function name="fn:translate-result" as="xs:string">
        <xsl:param name="result"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="translate-result">
            <xsl:choose>
                <xsl:when test="$class='vulnerability'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Vulnerability Found</xsl:when>
                        <xsl:when test="$result='false'">Vulnerability Not Found</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'patch'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Unpatched</xsl:when>
                        <xsl:when test="$result='false'">Patched</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'compliance'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Pass</xsl:when>
                        <xsl:when test="$result='false'">Fail</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'inventory'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Installed</xsl:when>
                        <xsl:when test="$result='false'">Not Installed</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'miscellaneous'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Pass</xsl:when>
                        <xsl:when test="$result='false'">Fail</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="$translate-result"/>
    </xsl:function>
    
    <xsl:function name="fn:translate-result-css" as="xs:string">
        <xsl:param name="result"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="translate-result">
            <xsl:choose>
                <xsl:when test="$class='vulnerability'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">fail</xsl:when>
                        <xsl:when test="$result='false'">pass</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'patch'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">fail</xsl:when>
                        <xsl:when test="$result='false'">pass</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'compliance'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">pass</xsl:when>
                        <xsl:when test="$result='false'">fail</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'inventory'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">pass</xsl:when>
                        <xsl:when test="$result='false'">fail</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'miscellaneous'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">pass</xsl:when>
                        <xsl:when test="$result='false'">fail</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="$translate-result"/>
    </xsl:function>
    <!-- ************* END: Functions ************** -->
    
    <xsl:template match="/" xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5">
        <xsl:apply-templates select="oval_results"/>
    </xsl:template>
    
    <xsl:template match="oval-res:oval_results" xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5">
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> This XHTML page was generated by the Configuration Assessment Tool (CIS-CAT) from the Center for Internet Security </xsl:text>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> For further information, please visit the Center for Internet Security web site at http://benchmarks.cisecurity.org/ </xsl:text>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> transformation performed </xsl:text>
                <xsl:value-of select="current-dateTime()"/>
                <xsl:text> using </xsl:text>
                <xsl:value-of select="system-property('xsl:vendor')"/>
                <xsl:text> version </xsl:text>
                <xsl:value-of select="system-property('xsl:product-version')"/>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
                <meta name="date" content="{current-dateTime()}"/>
                
                <title>OVAL RESULTS</title>
                
                <xsl:element name="style" namespace="http://www.w3.org/1999/xhtml">
                    <xsl:attribute name="type" select="'text/css'"/>
                    <xsl:value-of select="normalize-space($css_content)" disable-output-escaping="yes"/>
                </xsl:element>
                
                <xsl:variable name="js">assessor-html.js</xsl:variable>
                <xsl:element name="script" namespace="http://www.w3.org/1999/xhtml">
                    <xsl:attribute name="type" select="'text/javascript'"/>
                    <xsl:value-of select="unparsed-text(resolve-uri($js,static-base-uri()))" disable-output-escaping="yes"/>
                </xsl:element>
            </head>
            <body>
                <div id="reportContainer">
                    <xsl:variable name="bVulnerability"
                                    as="xs:boolean" 
                                select="count( oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'vulnerability' ] ) > 0"/>
                    <xsl:variable name="bInventory" 
                                    as="xs:boolean" 
                                select="count( oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'inventory' ] ) > 0"/>
                    <xsl:variable name="bCompliance" 
                                    as="xs:boolean" 
                                select="count( oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'compliance' ] ) > 0"/>
                    <xsl:variable name="bPatch" 
                                    as="xs:boolean" 
                                select="count( oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'patch' ] ) > 0"/>
                    <xsl:variable name="bMiscellaneous" 
                                    as="xs:boolean" 
                                select="count( oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'miscellaneous' ] ) > 0"/>
                    
                    <!-- START: Cover Page -->
                    <div class="coverPage">
                        <xsl:attribute name="style">
                            <xsl:text>background:url(data:image/gif;base64,</xsl:text>
                            <xsl:value-of select="$cover_page_url"/>
                            <xsl:text>) no-repeat;</xsl:text>
                        </xsl:attribute>
                        
                        <div class="logoContainer">
                            <span class="logoBar">
                                <xsl:element name="img">
                                    <xsl:attribute name="src">
                                        <xsl:text>data:image/png;base64,</xsl:text>
                                        <xsl:value-of select="$logo_url"/>
                                    </xsl:attribute>
                                </xsl:element>
                            </span>
                        </div>
                        
                        <div id="coverPageTitle">
                            <h1><a name="top"/>OVAL Definitions Assessment Report <br/>for <xsl:value-of select="oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_info/oval-sc:primary_host_name"/></h1>
                        </div>
                        
                        <div id="coverPageSubTitle">
                            <xsl:attribute name="style">
                                <xsl:text>background:url(data:image/gif;base64,</xsl:text>
                                <xsl:value-of select="$cover_page_subtitle_url"/>
                                <xsl:text>) no-repeat;</xsl:text>
                            </xsl:attribute>
                            <xsl:if test="$bVulnerability or $bCompliance or $bInventory or $bPatch or $bMiscellaneous">
                                <h3>Definition Classifications Assessed:</h3>
                                <ul>
                                    <xsl:if test="$bVulnerability">
                                        <li>Vulnerability</li>
                                    </xsl:if>
                                    <xsl:if test="$bCompliance">
                                        <li>Compliance</li>
                                    </xsl:if>
                                    <xsl:if test="$bInventory">
                                        <li>Inventory</li>
                                    </xsl:if>
                                    <xsl:if test="$bPatch">
                                        <li>Patch</li>
                                    </xsl:if>
                                    <xsl:if test="$bMiscellaneous">
                                        <li>Miscellaneous</li>
                                    </xsl:if>
                                    <li>
                                        <xsl:value-of select="format-dateTime(adjust-dateTime-to-timezone(oval-res:generator/oval:timestamp),'[FNn], [MNn] [D1] [Y0001] [H01]:[m01]:[s01]')"/>
                                    </li>
                                </ul>
                            </xsl:if>
                        </div>

                        <xsl:choose>
                            <xsl:when test="not($cover_page_footer_url = 'DEFAULT')">
                                <div class="coverpageFooterContainer">
                                    <span class="coverpageFooterBar">
                                        <xsl:element name="img">
                                            <xsl:attribute name="src">
                                                <xsl:text>data:image/png;base64,</xsl:text>
                                                <xsl:value-of select="$cover_page_footer_url"/>
                                            </xsl:attribute>
                                        </xsl:element>
                                    </span>
                                </div>
                            </xsl:when>
                            <xsl:when test="$include_default_coverpage_footer and $cover_page_footer_url = 'DEFAULT' ">
                                <div class="introFooter">
                                    <p>Report generated by the Center for Internet Security's Configuration Assessment Tool (CIS-CAT Pro Assessor) <xsl:if test="oval-res:generator/oval:product_version">
                                        <xsl:text> v</xsl:text>
                                        <xsl:value-of select="oval-res:generator/oval:product_version"/>
                                    </xsl:if>. </p>
                                    <p> For further information, please visit <a href="http://benchmarks.cisecurity.org">The Center for Internet Security</a> or our <a href="https://www.cisecurity.org/support/">Product Support</a> page. </p>
                                    <p>Copyright ©<xsl:value-of select="format-dateTime(adjust-dateTime-to-timezone(oval-res:generator/oval:timestamp),'[Y0001]')"/>, The Center for Internet Security</p>
                                </div>
                            </xsl:when>
                        </xsl:choose>
                    </div>
                    <!-- END: Cover Page -->
                    
                    <div id="detailsContainer">
                        <!-- START: "Summary" -->
                        <div id="summary">
                            <h2 class="sectionTitle">
                                <a name="target_summary"/>
                                <xsl:text>Target Summary</xsl:text>
                            </h2>
                            <xsl:variable as="node()" name="SystemInfo" select="oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_info"/>
                            
                            <!-- start -->
                            <table class="enum" width="100%">
                                <thead>
                                    <tr>
                                        <th align="left" colspan="2">Target System</th>
                                    </tr>
                                </thead>
                                <tr>
                                    <td class="enum_name" width="50%">Target Name</td>
                                    <td width="50%">
                                        <xsl:value-of select="$SystemInfo/oval-sc:primary_host_name"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="enum_name" width="50%">Target OS</td>
                                    <td width="50%">
                                        <xsl:value-of select="$SystemInfo/oval-sc:os_name"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="enum_name" width="50%">OS Version</td>
                                    <td width="50%">
                                        <xsl:value-of select="$SystemInfo/oval-sc:os_version"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="enum_name" width="50%">OS Architecture</td>
                                    <td width="50%">
                                        <xsl:value-of select="$SystemInfo/oval-sc:architecture"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <table class="enum" width="100%">
                                            <thead>
                                                <tr>
                                                    <th align="left" colspan="3">Network Interfaces</th>
                                                </tr>
                                            </thead>
                                            <tr>
                                                <td class="enum_name underline" width="50%">Interface Name</td>
                                                <td class="enum_name underline" width="25%">IP Address</td>
                                                <td class="enum_name underline" width="25%">MAC Address</td>
                                            </tr>
                                            <xsl:for-each select="$SystemInfo/oval-sc:interfaces/oval-sc:interface">
                                                <tr>
                                                    <td width="50%"><xsl:value-of select="oval-sc:interface_name"/></td>
                                                    <td width="25%"><xsl:value-of select="oval-sc:ip_address"/></td>
                                                    <td width="25%"><xsl:value-of select="oval-sc:mac_address"/></td>
                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <table class="enum" width="100%">
                                            <thead>
                                                <tr>
                                                    <th align="left" colspan="5">Definition Profile</th>
                                                </tr>
                                            </thead>
                                            <xsl:if test="$bVulnerability">
                                                <tr>
                                                    <td class="enum_name underline" width="20%">Vulnerability</td>
                                                    <td class="enum_name underline" width="20%">Not Found</td>
                                                    <td class="enum_name underline" width="20%">Found</td>
                                                    <td class="enum_name underline" width="20%">Error</td>
                                                    <td class="enum_name underline" width="20%">N/A</td>
                                                </tr>
                                                <xsl:call-template name="construct-target-summary"><xsl:with-param name="class">vulnerability</xsl:with-param></xsl:call-template>
                                            </xsl:if>
                                            
                                            <xsl:if test="$bInventory">
                                                <tr>
                                                    <td class="enum_name underline" width="20%">Inventory</td>
                                                    <td class="enum_name underline" width="20%">Installed</td>
                                                    <td class="enum_name underline" width="20%">Not Installed</td>
                                                    <td class="enum_name underline" width="20%">Error</td>
                                                    <td class="enum_name underline" width="20%">N/A</td>
                                                </tr>
                                                <xsl:call-template name="construct-target-summary"><xsl:with-param name="class">inventory</xsl:with-param></xsl:call-template>
                                            </xsl:if>
                                            
                                            <xsl:if test="$bCompliance">
                                                <tr>
                                                    <td class="enum_name underline" width="20%">Compliance</td>
                                                    <td class="enum_name underline" width="20%">Compliant</td>
                                                    <td class="enum_name underline" width="20%">Non-Compliant</td>
                                                    <td class="enum_name underline" width="20%">Error</td>
                                                    <td class="enum_name underline" width="20%">N/A</td>
                                                </tr>
                                                <xsl:call-template name="construct-target-summary"><xsl:with-param name="class">compliance</xsl:with-param></xsl:call-template>
                                            </xsl:if>
                                            
                                            <xsl:if test="$bPatch">
                                                <tr>
                                                    <td class="enum_name underline" width="20%">Patch</td>
                                                    <td class="enum_name underline" width="20%">Patched</td>
                                                    <td class="enum_name underline" width="20%">Unpatched</td>
                                                    <td class="enum_name underline" width="20%">Error</td>
                                                    <td class="enum_name underline" width="20%">N/A</td>
                                                </tr>
                                                <xsl:call-template name="construct-target-summary"><xsl:with-param name="class">patch</xsl:with-param></xsl:call-template>
                                            </xsl:if>
                                            
                                            <xsl:if test="$bMiscellaneous">
                                                <tr>
                                                    <td class="enum_name underline" width="20%">Miscellaneous</td>
                                                    <td class="enum_name underline" width="20%">True</td>
                                                    <td class="enum_name underline" width="20%">False</td>
                                                    <td class="enum_name underline" width="20%">Error</td>
                                                    <td class="enum_name underline" width="20%">N/A</td>
                                                </tr>
                                                <xsl:call-template name="construct-target-summary"><xsl:with-param name="class">miscellaneous</xsl:with-param></xsl:call-template>
                                            </xsl:if>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            <!-- end -->
                        </div>
                        
                        <hr/>
                        
                        <div id="checklist">
                            <h2 class="sectionTitle">
                                <a name="assessment_summary"/>
                                <xsl:text>Assessment Summary</xsl:text>
                            </h2>
                            
                            <table width="100%">
                                <col align="left"/>
                                <col align="center"/>
                                <thead>
                                    <tr>
                                        <th width="70%">Assessment Type</th>
                                        <th width="15%">Count</th>
                                        <th width="15%">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:if test="$bVulnerability">
                                        <tr>
                                            <td class="group sub0"><a href="#vulnerability-results">Vulnerabilities Found</a></td>
                                            <xsl:call-template name="construct-summary"><xsl:with-param name="class">vulnerability</xsl:with-param></xsl:call-template>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="$bInventory">
                                        <tr>
                                            <td class="group sub0"><a href="#inventory-results">Inventoried Items</a></td>
                                            <xsl:call-template name="construct-summary"><xsl:with-param name="class">inventory</xsl:with-param></xsl:call-template>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="$bCompliance">
                                        <tr>
                                            <td class="group sub0"><a href="#compliance-results">Compliance Failures</a></td>
                                            <xsl:call-template name="construct-summary"><xsl:with-param name="class">compliance</xsl:with-param></xsl:call-template>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="$bPatch">
                                        <tr>
                                            <td class="group sub0"><a href="#patch-results">Unpatched Items</a></td>
                                            <xsl:call-template name="construct-summary"><xsl:with-param name="class">patch</xsl:with-param></xsl:call-template>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="$bMiscellaneous">
                                        <tr>
                                            <td class="group sub0"><a href="#misc-results">Miscellaneous Items</a></td>
                                            <xsl:call-template name="construct-summary"><xsl:with-param name="class">miscellaneous</xsl:with-param></xsl:call-template>
                                        </tr>
                                    </xsl:if>
                                </tbody>
                            </table>
                        </div>
                        <!-- END: "Summary" -->
                        
                        <hr/>
                        
                        <!-- START: Vulnerabilities -->
                        <xsl:if test="$bVulnerability = true()">
                            <div>
                                <h2 class="sectionTitle">
                                    <a name="vulnerability-results"/>
                                    <xsl:text>Vulnerability Assessment Results</xsl:text>
                                </h2>
                                <table id="assessmentResultTable" width="100%">
                                    <thead>
                                        <tr>
                                            <!--<th>Seq#</th>-->
                                            <th>Vulnerability Desc</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:apply-templates select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'vulnerability' ]" mode="toc"/>
                                    </tbody>
                                </table>
                                <div class="backtop">
                                    <a href="#top" title="back to top">⇧</a>
                                </div>
                            </div>
                            
                            <div id="assessmentDetailsArea">
                                <h2 class="sectionTitle">
                                    <a name="details"/>
                                    <xsl:text>Vulnerability Details</xsl:text>
                                </h2>
                                <xsl:variable name="vdefs" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'vulnerability' ]"/>
                                <xsl:for-each select="$vdefs">
                                    <xsl:variable name="vdefid" select="@id"/>
                                    <xsl:variable name="vdresult" as="node()"
                                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $vdefid]"/>
                                    
                                    <xsl:apply-templates select="$vdresult" mode="details"/>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <!-- END: Vulnerabilities -->
                        
                        <!-- START: Inventory -->
                        <xsl:if test="$bInventory = true()">
                            <div>
                                <h2 class="sectionTitle">
                                    <a name="inventory-results"/>
                                    <xsl:text>Inventory Assessment Results</xsl:text>
                                </h2>
                                <table id="assessmentResultTable" width="100%">
                                    <thead>
                                        <tr>
                                            <!--<th>Seq#</th>-->
                                            <th>Inventoried Item</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:apply-templates select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'inventory' ]" mode="toc"/>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div id="assessmentDetailsArea">
                                <h2 class="sectionTitle">
                                    <a name="details"/>
                                    <xsl:text>Inventory Details</xsl:text>
                                </h2>
                                <xsl:variable name="idefs" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'inventory' ]"/>
                                <xsl:for-each select="$idefs">
                                    <xsl:variable name="idefid" select="@id"/>
                                    <xsl:variable name="idefresult" as="node()" 
                                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $idefid]"/>
                                    
                                    <xsl:apply-templates select="$idefresult" mode="details"/>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <!-- END: Inventory -->
                        
                        <!-- START: Compliance -->
                        <xsl:if test="$bCompliance = true()">
                            <div>
                                <h2 class="sectionTitle">
                                    <a name="compliance-results"/>
                                    <xsl:text>Compliance Assessment Results</xsl:text>
                                </h2>
                                <table id="assessmentResultTable" width="100%">
                                    <thead>
                                        <tr>
                                            <!--<th>Seq#</th>-->
                                            <th>Assessed Item</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:apply-templates select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'compliance' ]" mode="toc"/>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div id="assessmentDetailsArea">
                                <h2 class="sectionTitle">
                                    <a name="details"/>
                                    <xsl:text>Assessment Details</xsl:text>
                                </h2>
                                <xsl:variable name="compdefs" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'compliance' ]"/>
                                <xsl:for-each select="$compdefs">
                                    <xsl:variable name="compdefid" select="@id"/>
                                    <xsl:variable name="compdefresult" as="node()" 
                                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $compdefid]"/>
                                    
                                    <xsl:apply-templates select="$compdefresult" mode="details"/>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <!-- END: Compliance -->
                        
                        <!-- START: Patches -->
                        <xsl:if test="$bPatch = true()">
                            <div>
                                <h2 class="sectionTitle">
                                    <a name="patch-results"/>
                                    <xsl:text>Patch Assessment Results</xsl:text>
                                </h2>
                                <table id="assessmentResultTable" width="100%">
                                    <thead>
                                        <tr>
                                            <!--<th>Seq#</th>-->
                                            <th>Patch Desc.</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:apply-templates select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'patch' ]" mode="toc"/>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div id="assessmentDetailsArea">
                                <h2 class="sectionTitle">
                                    <a name="details"/>
                                    <xsl:text>Patch Details</xsl:text>
                                </h2>
                                <xsl:variable name="pdefs" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'patch' ]"/>
                                <xsl:for-each select="$pdefs">
                                    <xsl:variable name="pdefid" select="@id"/>
                                    <xsl:variable name="pdefresult" as="node()" 
                                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $pdefid]"/>
                                    
                                    <xsl:apply-templates select="$pdefresult" mode="details"/>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <!-- END: Patches -->
                        
                        <!-- START: Misc -->
                        <xsl:if test="$bMiscellaneous = true()">
                            <div>
                                <h2 class="sectionTitle">
                                    <a name="misc-results"/>
                                    <xsl:text>Miscellaneous Assessment Results</xsl:text>
                                </h2>
                                <table id="assessmentResultTable" width="100%">
                                    <thead>
                                        <tr>
                                            <!--<th>Seq#</th>-->
                                            <th>Desc.</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:apply-templates select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'miscellaneous' ]" mode="toc"/>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div id="assessmentDetailsArea">
                                <h2 class="sectionTitle">
                                    <a name="details"/>
                                    <xsl:text>Miscellaneous Details</xsl:text>
                                </h2>
                                <xsl:variable name="miscdefs" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = 'miscellaneous' ]"/>
                                <xsl:for-each select="$miscdefs">
                                    <xsl:variable name="miscdefid" select="@id"/>
                                    <xsl:variable name="miscdefresult" as="node()" 
                                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $miscdefid]"/>
                                    
                                    <xsl:apply-templates select="$miscdefresult" mode="details"/>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <!-- END: Misc -->
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="oval-def:definition" mode="toc">
        <xsl:if test="oval-def:metadata/oval-def:title">
            <xsl:variable name="def_id" select="@id"/>
            <xsl:variable name="class" select="@class"/>
            <xsl:variable name="result" 
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$def_id]/@result"/>
            <xsl:variable 
                name="definition_result" 
                select="fn:translate-result($result, $class)"/>
            
            <xsl:variable 
                name="definition_css" 
                select="fn:translate-result-css($result, $class)"/>
            
            <xsl:variable name="display" as="xs:boolean">
                <xsl:choose>
                    <xsl:when test="@class = 'vulnerability' and $result = 'true'">true</xsl:when>
                    <xsl:when test="@class = 'inventory' and $result = 'true'">true</xsl:when>
                    <xsl:when test="@class = 'compliance' and $result = 'false'">true</xsl:when>
                    <xsl:when test="@class = 'patch' and $result = 'true'">true</xsl:when>
                    <xsl:when test="@class = 'miscellaneous' and $result = 'false'">true</xsl:when>
                    <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <xsl:choose>
                <xsl:when test="$display = true()">
                    <tr>
                        <!--<td>
                            <xsl:number count="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @class = $class ]" level="multiple"/>
                        </td>-->
                        <td width="80%">
                            <a href="#detail-{$def_id}"><xsl:value-of select="oval-def:metadata/oval-def:title"/></a>
                        </td>
                        <td width="20%" align="right" class="{$definition_css}">
                            <xsl:value-of select="$definition_result"/>
                        </td>
                    </tr>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="oval-def:oval_definitions" mode="details">
        <xsl:apply-templates select="oval-def:definitions" mode="details"/>
    </xsl:template>
    
    <xsl:template match="oval-def:definitions" mode="details">
        <!--<xsl:apply-templates select="oval-def:definition[@class='vulnerability']"/>-->
        <xsl:apply-templates select="oval-def:definition" mode="details"/>
    </xsl:template>
    
    <xsl:template match="oval-res:definition" mode="details">
        <xsl:variable name="def_id" select="@definition_id"/>
        <xsl:variable name="class" select="@class"/>
        <xsl:variable name="def" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[@id = $def_id]"/>
        <xsl:variable name="result" select="@result"/>
        
        <xsl:variable name="display" as="xs:boolean">
            <xsl:choose>
                <xsl:when test="@class = 'vulnerability' and $result = 'true'">true</xsl:when>
                <xsl:when test="@class = 'inventory' and $result = 'true'">true</xsl:when>
                <xsl:when test="@class = 'compliance' and $result = 'false'">true</xsl:when>
                <xsl:when test="@class = 'patch' and $result = 'true'">true</xsl:when>
                <xsl:when test="@class = 'miscellaneous' and $result = 'false'">true</xsl:when>
                <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$display = true()">
                <xsl:variable name="definition_result" select="fn:translate-result($result, $class)"/>
                <xsl:variable name="definition_css"    select="fn:translate-result-css($result, $class)"/>
                
                <div class="Rule" id="detail-{$def_id}">
                    <span class="outcome {$definition_css} ruleResultArea">
                        <xsl:value-of select="$definition_result"/>
                    </span>
                    
                    <h3 class="ruleTitle">
                        <xsl:attribute name="title">
                            <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:value-of select="$def/oval-def:metadata/oval-def:title"/>
                    </h3>
                    
                    <xsl:apply-templates select="$def/oval-def:metadata" mode="details"/>
                    
                    <xsl:if test="exists($def/oval-def:notes)">
                        <span class="bold">
                            <xsl:text>Notes: </xsl:text>
                        </span>
                        <xsl:for-each select="$def/oval-def:notes/oval:note">
                            <p><xsl:value-of select="."/></p>
                        </xsl:for-each>
                    </xsl:if>
                    
                    <span class="bold">
                        <xsl:text>Assessment Criteria: </xsl:text>
                    </span>
                    <xsl:apply-templates select="oval-res:criteria" mode="ROOT-EVIDENCE"/>
                    
                    <div class="backtop">
                        <a href="#assessment_summary" title="back to summary">Back to Summary</a>
                    </div>
                </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="oval-res:criteria" mode="ROOT-EVIDENCE">
        <table width="100%" class="evidence">
            <!-- Only display the ALL msg if there's more than one test|and|or below the root <and> -->
            <xsl:choose>
                <xsl:when test="count(child::*) > 1">
                    <tr>
                        <xsl:choose>
                            <xsl:when test="@operator = 'AND'">
                                <td class="evidence" width="85%">All of the following criteria, criterion, and extend definitions must pass:</td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="evidence" width="85%">Any of the following criteria, criterion, and extend definitions must pass:</td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <td class="evidence" width="15%" align="right"><xsl:value-of select="@result"/></td>
                    </tr>
                </xsl:when>
                <xsl:otherwise>
                    <tr>
                        <td class="evidence" width="85%">The following criterion must pass:</td>
                        <td class="evidence" width="15%" align="right"><xsl:value-of select="@result"/></td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
            <tr>
                <td colspan="2">
                    <xsl:choose>
                        <xsl:when test="oval-res:criteria|oval-res:criterion|oval-res:extend_definition">
                            <xsl:apply-templates select="oval-res:criteria|oval-res:criterion|oval-res:extend_definition" mode="EVIDENCE"/>
                        </xsl:when>
                        <xsl:otherwise>None</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="oval-res:criteria" mode="EVIDENCE">
        <table width="100%" class="evidence">
            <xsl:choose>
                <xsl:when test="count(child::*) > 1">
                    <tr>
                        <xsl:choose>
                            <xsl:when test="@operator = 'AND'">
                                <td class="evidence" width="85%">All of the following criteria, criterion, and extend definitions must pass:</td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="evidence" width="85%">Any of the following criteria, criterion, and extend definitions must pass:</td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <td class="evidence" width="15%" align="right"><xsl:value-of select="@result"/></td>
                    </tr>
                </xsl:when>
                <xsl:otherwise>
                    <tr>
                        <td class="evidence" width="85%">The following criterion must pass:</td>
                        <td class="evidence" width="15%" align="right"><xsl:value-of select="@result"/></td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
            <tr>
                <td colspan="2">
                    <xsl:choose>
                        <xsl:when test="oval-res:criteria|oval-res:criterion|oval-res:extend_definition">
                            <xsl:apply-templates select="oval-res:criteria|oval-res:criterion|oval-res:extend_definition" mode="EVIDENCE"/>
                        </xsl:when>
                        <xsl:otherwise>None</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="oval-res:criterion" mode="EVIDENCE">
        <table width="100%" class="evidence">
            <tr>
                <td width="70%">Criterion: <xsl:value-of select="@test_ref"/></td>
                <td width="30%" align="right"><xsl:value-of select="@result"/></td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="oval-res:extend_definition" mode="EVIDENCE">
        <xsl:variable name="edid" select="@definition_ref"/>
        <xsl:variable name="edresult" as="node()" 
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id = $edid]"/>
        
        <table width="100%" class="evidence" style="border-bottom: 1px solid black;">
            <tr>
                <td width="70%">Extend Definition: <xsl:value-of select="@definition_ref"/></td>
                <td width="30%" align="left"><xsl:value-of select="@result"/></td>
            </tr>
            <tr>
                <td colspan="2" style="padding-left: 15px;">
                    <xsl:apply-templates select="$edresult/oval-res:criteria" mode="ROOT-EVIDENCE"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="oval-def:metadata" mode="details">
        <span class="bold">
            <xsl:text>Description: </xsl:text>
        </span>
        <p><xsl:value-of select="oval-def:description"/></p>
        
        <xsl:if test="oval-def:affected">
            <span class="bold">
                <xsl:text>Applicable Platforms: </xsl:text>
            </span>
            <ul>
                <xsl:for-each select="oval-def:affected">
                    <xsl:for-each select="oval-def:platform">
                        <li><xsl:value-of select="."/></li>
                    </xsl:for-each>
                </xsl:for-each>
            </ul>
        </xsl:if>
        
        <xsl:if test="oval-def:reference[@source='CVE' or @source='http://cce.mitre.org']">
            <span class="bold">
                <xsl:text>References: </xsl:text>
            </span>
            <ul>
                <xsl:apply-templates select="oval-def:reference" mode="details"/>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="oval-res:criteria" mode="details">
        <xsl:apply-templates select="oval-res:criteria|oval-res:criterion|oval-res:extend_definition" mode="details"/>
    </xsl:template>
    
    <xsl:template match="oval-res:criterion" mode="details">
        <table width="100%" class="evidence">
            <tr>
                <td><xsl:value-of select="@test_ref"/></td>
                <td><xsl:value-of select="@result"/></td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="oval-res:extend_definition" mode="details">
        <xsl:variable name="d" select="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = ./@definition_id ]"/>
        <xsl:value-of select="$d/oval-def:metadata/oval-def:title"/>
        <xsl:apply-templates select="$d/oval-def:criteria"/>
    </xsl:template>
    
    <xsl:template match="oval-def:reference[@source='CVE']" mode="details">
        <xsl:variable name="ref_id" select="@ref_id"/>
        <xsl:variable name="cve-year" as="xs:double" select="number(substring($ref_id, 5, 4))"/>
        <xsl:variable name="cve-document">
            <xsl:choose>
                <xsl:when test="$cve-year &lt; 2002 or $cve-year = 2002">
                    <xsl:value-of select="concat('cve/nvdcve_cve_cvss_map-', '2002', '.xml')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('cve/nvdcve_cve_cvss_map-', string($cve-year), '.xml')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="cve-available" select="doc-available($cve-document)"/>
        <xsl:choose>
            <xsl:when test="$cve-available">
                <xsl:variable name="cve_node" select="doc($cve-document)/cve:cve_cvss_map/cve:entry[ @id = $ref_id]"/>
                <xsl:choose>
                    <xsl:when test="$cve_node">
                        <li>
                            <b>CVE-ID: </b>
                            <xsl:element name="a">
                                <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                                <xsl:value-of select="$ref_id"/>
                            </xsl:element>
                            <xsl:text> -- </xsl:text>
                            
                            <span class="evidence-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                            <div class="cveevidence rule-xml" id="{generate-id()}_xml">
                                <table class="enum" width="100%">
                                    <thead>
                                        <tr>
                                            <th colspan="2">CVE Information</th>
                                        </tr>
                                    </thead>
                                    <tr style="border-bottom: 1px solid black">
                                        <td class="enum_name" width="20%">Vector Description:</td>
                                        <td width="80%">
                                            <!-- 
                                                This vulnerability, having a complexity of (low,medium,high) can be exploited by a (authenticated|unauthenticated) principal 
                                                originating from (the local computer|any network|adjacent network]. If exploited, the impact to confidentiality, integrity, 
                                                and availability is None, None, Partial, respectively. This vulnerabilities' CVSS base score is Z.
                                            -->
                                            <xsl:text>This vulnerability (</xsl:text>
                                            <xsl:value-of select="$cve_node/@id"/>
                                            <xsl:text>), having a complexity of </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@acp"/></b>
                                            <xsl:text> can be exploited by an </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@aup"/></b>
                                            <xsl:text> principal originating from </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@avp"/></b>
                                            <xsl:text>.  If exploited, the impact to confidentiality, integrity, and availability is </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@cip"/></b>
                                            <xsl:text>, </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@iip"/></b>
                                            <xsl:text>, and </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@aip"/></b>
                                            <xsl:text>, respectively.  This vulnerabilities' CVSS base score is </xsl:text>
                                            <b><xsl:value-of select="$cve_node/@cvss_base"/></b>
                                            <xsl:text>.</xsl:text>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="enum_name" width="20%">Summary:</td>
                                        <td width="80%">
                                            <xsl:value-of select="$cve_node/text()"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="enum_name" width="20%">Severity:</td>
                                        <td width="80%">
                                            <xsl:value-of select="$cve_node/@cvss_base"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="enum_name" width="20%">Access Vector:</td>
                                        <td width="80%">
                                            <xsl:value-of select="$cve_node/@cvss_vector_string"/>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </li>
                    </xsl:when>
                    <xsl:otherwise>
                        <li>
                            <b>CVE-ID: </b>
                            <xsl:element name="a">
                                <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                                <xsl:value-of select="$ref_id"/>
                            </xsl:element>
                        </li>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <li>
                    <b>CVE-ID: </b>
                    <xsl:element name="a">
                        <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                        <xsl:value-of select="$ref_id"/>
                    </xsl:element>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="oval-def:reference[@source='http://cce.mitre.org']" mode="details">
        <xsl:variable name="cce_id" select="@ref_id"/>
        <xsl:variable name="cce_node" select="doc('cce/nvd_cce_map.xml')/cce:cce_map/cce:cce_entry[ @id = $cce_id]"/>
        <li>
            <b>CCE-IDv5: </b>
            <a href="http://cce.mitre.org/" class="CCE-link">
                <xsl:value-of select="$cce_id"/>
            </a>
            <table class="enum" width="100%">
                <thead>
                    <tr>
                        <th colspan="2">CCE Information</th>
                    </tr>
                </thead>
                <tr>
                    <td class="enum_name" width="20%">CCE-IDv5:</td>
                    <td width="80%"><xsl:value-of select="$cce_id"/></td>
                </tr>
                <tr>
                    <td class="enum_name" width="20%">Published On:</td>
                    <td width="80%"><xsl:value-of select="format-dateTime($cce_node/@published, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                </tr>
                <tr>
                    <td class="enum_name" width="20%">Last Modified On:</td>
                    <td width="80%"><xsl:value-of select="format-dateTime($cce_node/@modified, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                </tr>
                
                <xsl:if test="$cce_node/scap-core:control-mappings">
                    <tr>
                        <td colspan="2">
                            <table class="enum" width="100%">
                                <thead>
                                    <tr>
                                        <th colspan="2">Compliance Mappings</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="$cce_node/scap-core:control-mappings/scap-core:control-mapping">
                                        <tr>
                                            <td class="enum_name" width="20%">Last Modified:</td>
                                            <td width="80%"><xsl:value-of select="format-dateTime(./@last-modified, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="enum_name" width="20%">Source:</td>
                                            <td width="80%">
                                                <xsl:element name="a">
                                                    <xsl:attribute name="href" select="./@source"/>
                                                    <xsl:value-of select="./@source"/>
                                                </xsl:element>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="enum_name" width="20%">System:</td>
                                            <td width="80%">
                                                <xsl:element name="a">
                                                    <xsl:attribute name="href" select="./@system-id"/>
                                                    <xsl:value-of select="./@system-id"/>
                                                </xsl:element>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <table class="enum" width="100%">
                                                    <thead>
                                                        <tr>
                                                            <th>Mapping</th>
                                                            <th>Published</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="./scap-core:mapping">
                                                            <tr>
                                                                <td width="20%"><xsl:value-of select="./text()"/></td>
                                                                <td width="80%"><xsl:value-of select="format-dateTime(./@published, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                                                            </tr>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </li>
    </xsl:template>
    
    <!-- *******************************************************************
         Callable template which constructs the "Summary" Table of Contents 
         ******************************************************************* -->
    <xsl:template name="construct-summary">
        <xsl:param name="class"/>
        
        <xsl:variable name="result_val">
            <xsl:choose>
                <xsl:when test="$class = 'vulnerability' or $class = 'patch' or $class = 'inventory'">true</xsl:when>
                <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <td class="numeric bold">
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and @result = $result_val] )"/>
        </td>
        <td class="numeric bold">
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class] )"/>
        </td>
        <!--<td class="numeric bold">
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and @result = 'error'] )"/>
        </td>
        <td class="numeric bold">
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and (@result = 'not applicable' or @result = 'not evaluated' or @result = 'unknown')] )"/>
        </td>-->
    </xsl:template>
    
    
    <xsl:template name="construct-target-summary">
        <xsl:param name="class"/>
        
        <xsl:variable name="pass_val">
            <xsl:choose>
                <xsl:when test="$class = 'vulnerability' or $class = 'patch'">false</xsl:when>
                <xsl:otherwise>true</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="fail_val">
            <xsl:choose>
                <xsl:when test="$class = 'vulnerability' or $class = 'patch'">true</xsl:when>
                <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <tr>
            <td width="20%"><xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class] )"/></td>
            <td width="20%"><xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and @result = $pass_val] )"/></td>
            <td width="20%"><xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and @result = $fail_val] )"/></td>
            <td width="20%"><xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and @result = 'error'] )"/></td>
            <td width="20%"><xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@class = $class and (@result = 'not applicable' or @result = 'not evaluated' or @result = 'unknown')] )"/></td>
        </tr>
    </xsl:template>
</xsl:transform>
