# List the system modules and Signature Info for each host
$Output =
	Foreach ($VMHost in Get-VMHost ) {
		$ESXCli = Get-EsxCli -V2 -VMHost $VMHost
		$arg1 = $ESXCli.system.module.list.CreateArgs()
		$arg1 = @{loaded = $true}
		$modules = $ESXCli.system.module.list.Invoke($arg1)
		Foreach ($module in $modules){
			$arg2 = $ESXCli.system.module.get.CreateArgs()
			$arg2 = @{module = $module.Name}
			$ESXCli.system.module.get.Invoke($arg2) | Select @{N="VMHost";E={$VMHost}}, Module, License, Modulefile, Version, SignedStatus, SignatureDigest, SignatureFingerPrint
		}
	}
$Output | ConvertTo-Csv -NoTypeInformation