/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.SpecialFolder;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveInputStream;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.VersionCheck;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JreInstaller {
    private String preferredJre = null;
    private File preferredJreFile;
    private long jreSize = -1L;
    private int jreCount = -1;
    private static final String JRE_DIR = "jre";
    private static final String JRE_TAR = "jre.tar";
    private static final String JRE_BUNDLE = "jre.bundle";
    private static final String SYSTEM_PREFS = ".systemPrefs";
    private static final boolean MANUAL_JRE = Boolean.getBoolean("exe4j.manualJre");
    private static final String USED_MAC_JRE_BUNDLE = System.getProperty("i4j.jreBundle");
    private static final String BUNDLED_MAC_TAR_FILE = System.getProperty("i4j.tarFile");
    private static final String REGKEY_SHARED_JVMS = "SOFTWARE\\ej-technologies\\install4j\\" + (Util.isWindows() && InstallerUtil.isAaarch64() ? "sharedjvms_arm64\\" : "sharedjvms\\");
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private File destinationDirectory = null;
    private boolean sharedInstallation;
    private static final String JRE_BACKUP_DIR = "__i4j_jre_backup";
    private static JreInstaller instance;

    public static synchronized JreInstaller getInstance() {
        if (instance == null) {
            instance = new JreInstaller();
        }
        return instance;
    }

    private JreInstaller() {
    }

    public void prepareUninstall(Context context, boolean uninstallForUpgrade) {
        if (!(uninstallForUpgrade || Util.isMacOS() || Util.isWindows())) {
            this.fileInstaller.deleteRecursive(new File(new File(context.getInstallationDirectory(), JRE_DIR), SYSTEM_PREFS));
        }
    }

    public long installJre(InstallerContext context, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long maxProgress, long currentProgress) throws IOException, UserCanceledException {
        File javaExe;
        this.updateDestinationDirectory(context.getInstallationDirectory());
        UninstallMode uninstallMode = UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        if (this.sharedInstallation) {
            uninstallMode = UninstallMode.NEVER;
        }
        if (InstallerUtil.isWindows()) {
            File jreSourceDir = InstallerUtil.getAbsoluteFile(new File(JRE_DIR));
            if (jreSourceDir.exists()) {
                this.prepareJreDestDir(uninstallMode);
                currentProgress = this.installDir(context, jreSourceDir, this.destinationDirectory, progressInterface, installFilesAction, maxProgress, currentProgress, uninstallMode);
            }
        } else if (Util.isMacosInstaller()) {
            this.prepareJreDestDir(uninstallMode);
            currentProgress = this.installDir(context, InstallerUtil.getAbsoluteFile(new File(USED_MAC_JRE_BUNDLE)), this.destinationDirectory, progressInterface, installFilesAction, maxProgress, currentProgress, uninstallMode);
        } else {
            File jreTarFile = InstallerUtil.getAbsoluteFile(new File(JRE_TAR));
            if (jreTarFile.exists()) {
                this.prepareJreDestDir(uninstallMode);
                currentProgress = this.installTar(context, jreTarFile, this.destinationDirectory, InstallerUtil.getAbsoluteFile(new File(JRE_DIR)), progressInterface, installFilesAction, maxProgress, currentProgress, uninstallMode);
            }
        }
        if (!Util.isMacosInstaller() && this.destinationDirectory != null && (javaExe = new File(this.destinationDirectory, "bin/java" + (InstallerUtil.isWindows() ? "w.exe" : ""))).exists() && !new File(this.destinationDirectory, "bin/jrockit").exists()) {
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/bin/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/bin/server/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/i386/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/sparc/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/amd64/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/i386/server/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/sparc/server/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(context.getDestinationFile("jre/lib/amd64/server/classes.jsa"));
            try {
                if (System.getProperty("java.vm.name", "").toLowerCase(Locale.ENGLISH).contains("hotspot")) {
                    new ProcessBuilder(javaExe.getAbsolutePath(), "-Xshare:dump").start();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return currentProgress;
    }

    private void prepareJreDestDir(UninstallMode uninstallMode) throws IOException {
        if (this.destinationDirectory.exists() && !this.destinationDirectory.renameTo(new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR))) {
            FileUtil.emptyDirectory(this.destinationDirectory);
        }
        FileInstaller.getInstance().createDirectory(this.destinationDirectory, uninstallMode);
        this.addPreferredJreToRegistry(this.destinationDirectory);
    }

    private void addPreferredJreToRegistry(File jreDir) {
        String keyName;
        String sharingKey;
        if (this.sharedInstallation && InstallerUtil.isWindows() && !(sharingKey = InstallerConfig.getCurrentInstance().getJreSharingKey()).isEmpty() && !WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, keyName = REGKEY_SHARED_JVMS + sharingKey + "\\" + jreDir.getAbsolutePath().replace('\\', '/') + "/bin/java.exe")) {
            WinRegistry.createKey(RegistryRoot.HKEY_CURRENT_USER, keyName);
        }
    }

    private void updateDestinationDirectory(File installationDirectory) {
        this.destinationDirectory = null;
        String sharingKey = InstallerConfig.getCurrentInstance().getJreSharingKey();
        if (!sharingKey.isEmpty()) {
            File sharedDir = null;
            if (Util.hasFullAdminRights() || InstallerUtil.isWindows()) {
                File parent = InstallerUtil.isWindows() ? FolderInfo.getCommonFilesDirectory() : new File(InstallerUtil.getStandardApplicationsDirectory(false));
                parent = new File(parent, "i4j_jres");
                sharedDir = JreInstaller.getSharedJreSubdir(new File(parent, sharingKey), Boolean.getBoolean("install4j.shareJreAppendBitness"));
            }
            if (sharedDir != null && InstallerUtil.checkWritableInstallationDirectory(sharedDir, false)) {
                this.sharedInstallation = true;
                this.destinationDirectory = sharedDir;
            } else {
                File programFilesCommon;
                if (InstallerUtil.isWindows() && (programFilesCommon = WinFileSystem.getSpecialFolder(SpecialFolder.PROGRAM_FILES_COMMON, false)) != null && InstallerUtil.checkWritableInstallationDirectory(sharedDir = JreInstaller.getSharedJreSubdir(new File(new File(programFilesCommon, "i4j_jres"), sharingKey), true), false)) {
                    this.sharedInstallation = true;
                    this.destinationDirectory = sharedDir;
                }
                if (this.destinationDirectory == null && InstallerUtil.checkWritableInstallationDirectory(sharedDir = JreInstaller.getSharedJreSubdir(new File(new File(JreInstaller.getUserAppDataDir(), "i4j_jres"), sharingKey), true), false)) {
                    this.sharedInstallation = true;
                    this.destinationDirectory = sharedDir;
                }
            }
        }
        if (this.destinationDirectory == null) {
            this.sharedInstallation = false;
            this.destinationDirectory = Util.isMacosInstaller() ? (InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle() ? new File(new File(installationDirectory, InstallerConfig.getCurrentInstance().getMacSpecificConfig().getSingleBundleName()), "Contents/PlugIns/jre.bundle") : new File(installationDirectory, ".install4j/jre.bundle")) : new File(installationDirectory, JRE_DIR);
        }
    }

    private static String getUserAppDataDir() {
        String appData = InstallerVariables.getStringVariable("sys.appdataDir");
        if (appData != null) {
            return appData;
        }
        return InstallerVariables.getAppDataDir();
    }

    private static File getSharedJreSubdir(File parent, boolean appendBitness) {
        String suffix;
        String version = InstallerConfig.getCurrentInstance().getJreVersion().trim();
        String string = suffix = InstallerUtil.isWindows() && InstallerUtil.isArm() ? "_arm" : "";
        if (appendBitness) {
            suffix = suffix + (InstallerUtil.is32BitJVM() ? "_32" : "_64");
        }
        if (!Objects.equals(version, "")) {
            return new File(parent, version + suffix);
        }
        int jreNumber = 1;
        File sharedJreDir = new File(parent, JRE_DIR + jreNumber + suffix);
        while (sharedJreDir.exists()) {
            sharedJreDir = new File(parent, JRE_DIR + ++jreNumber + suffix);
        }
        return sharedJreDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long installTar(InstallerContext context, File jreTarFile, File destDir, File unpackedDir, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long maxProgress, long currentProgress, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        TarArchiveInputStream in;
        try {
            FilterInputStream baseIn = new BufferedInputStream(new FileInputStream(jreTarFile));
            if (jreTarFile.getName().endsWith(".gz")) {
                try {
                    baseIn = new GZIPInputStream(baseIn);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            in = new TarArchiveInputStream(baseIn);
        }
        catch (Exception e) {
            throw new ReadIOException(e);
        }
        try {
            TarArchiveEntry tarEntry;
            try {
                tarEntry = in.getNextTarEntry();
            }
            catch (Exception e) {
                throw new ReadIOException(e);
            }
            while (tarEntry != null) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                boolean isPackedFile = false;
                String name = tarEntry.getName();
                if (name.endsWith("jar.pack")) {
                    name = name.substring(0, name.length() - 5);
                    isPackedFile = true;
                }
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(name));
                File destFile = new File(destDir, name);
                if (tarEntry.isSymbolicLink()) {
                    currentProgress += 153600L;
                    UnixFileSystem.createLink(tarEntry.getLinkName(), destFile);
                    this.fileInstaller.registerUninstallFile(destFile);
                } else if (tarEntry.isDirectory()) {
                    currentProgress += 153600L;
                    this.fileInstaller.createDirectory(destFile, uninstallMode);
                } else {
                    long nextProgress = currentProgress + 153600L + tarEntry.getSize();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setMode(tarEntry.getMode());
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(tarEntry.getModTime().getTime());
                    fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
                    if (isPackedFile) {
                        this.fileInstaller.install(new File(unpackedDir, name), destFile, fileOptions, new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress)));
                    } else {
                        this.fileInstaller.install(in, destFile, fileOptions, new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress)), tarEntry.getSize(), false);
                    }
                    currentProgress = nextProgress;
                }
                progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
                try {
                    tarEntry = in.getNextTarEntry();
                }
                catch (Exception e) {
                    throw new ReadIOException(e);
                    return currentProgress;
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                throw new ReadIOException(e);
            }
        }
    }

    private long installDir(InstallerContext context, File sourceDir, File destDir, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long maxProgress, long currentProgress, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        File[] children = sourceDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(child.getName()));
                File destFile = new File(destDir, child.getName());
                if (this.handledSymlink(child, destFile)) continue;
                if (child.isDirectory()) {
                    this.fileInstaller.createDirectory(destFile, uninstallMode);
                    currentProgress = this.installDir(context, child, destFile, progressInterface, installFilesAction, maxProgress, currentProgress, uninstallMode);
                    currentProgress += 153600L;
                } else {
                    long nextProgress = currentProgress + 153600L + child.length();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(child.lastModified());
                    fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
                    this.fileInstaller.install(child, destFile, fileOptions, new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress)));
                    this.updatePosixMode(child, destFile);
                    currentProgress = nextProgress;
                }
                progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
            }
        }
        return currentProgress;
    }

    private void updatePosixMode(File sourceFile, File destFile) throws IOException {
        if (Util.isMacosInstaller() && sourceFile.exists() && destFile.exists()) {
            String mode = FileAttributesHelper.getPosixFilePermissions(sourceFile);
            UnixFileSystem.setMode(mode, destFile);
        }
    }

    private boolean handledSymlink(File sourceFile, File destFile) throws IOException {
        if (Util.isMacosInstaller() && Files.isSymbolicLink(sourceFile.toPath())) {
            destFile.delete();
            String target = Files.readSymbolicLink(sourceFile.toPath()).toString();
            UnixFileSystem.createLink(target, destFile);
            this.fileInstaller.registerUninstallFile(destFile);
            return true;
        }
        return false;
    }

    public boolean checkJreInstallation(File installationDirectory) throws IOException {
        this.updateDestinationDirectory(installationDirectory);
        if (MANUAL_JRE && this.preferredJre == null) {
            try {
                String javaHome = new File(System.getProperty("java.home")).getCanonicalPath();
                if (!javaHome.startsWith(new File(System.getProperty("user.dir")).getCanonicalPath())) {
                    this.preferredJre = javaHome;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean hasJreBundle = false;
        if (Util.isMacosInstaller()) {
            if (BUNDLED_MAC_TAR_FILE != null) {
                hasJreBundle = true;
            } else if (!(USED_MAC_JRE_BUNDLE == null || USED_MAC_JRE_BUNDLE.startsWith("/System") || USED_MAC_JRE_BUNDLE.startsWith("/Library") || Objects.equals(this.destinationDirectory.getCanonicalPath(), new File(USED_MAC_JRE_BUNDLE).getCanonicalPath()))) {
                String version = this.getCurrentMacJreVersion();
                if (version == null) {
                    Logger.getInstance().log(this, "JRE will be copied from " + USED_MAC_JRE_BUNDLE, true);
                    hasJreBundle = true;
                } else {
                    Logger.getInstance().log(this, "Current installed JRE version at " + this.destinationDirectory + " is " + version, true);
                    if (!VersionCheck.checkJavaVersionCompatible(InstallerConfig.getCurrentInstance().getMinJavaVersion(), version)) {
                        Logger.getInstance().log(this, "JRE will be replaced", true);
                        hasJreBundle = true;
                    }
                }
            }
        } else {
            boolean bl = hasJreBundle = InstallerUtil.getAbsoluteFile(new File(JRE_DIR)).exists() && (InstallerUtil.isWindows() || InstallerUtil.getAbsoluteFile(new File(JRE_TAR)).exists());
        }
        if (hasJreBundle) {
            if (this.preferredJre == null) {
                this.preferredJre = this.destinationDirectory.getAbsolutePath();
            }
            if (this.sharedInstallation || Boolean.getBoolean("install4j.preventJreBundleUpdate")) {
                return !this.destinationDirectory.isDirectory() || !JreInstaller.anyIsFile(this.destinationDirectory, "lib/rt.jar", "jre/lib/rt.jar", "lib/modules");
            }
            return true;
        }
        return false;
    }

    private static boolean anyIsFile(File baseDir, String ... names) {
        for (String name : names) {
            if (!new File(baseDir, name).isFile()) continue;
            return true;
        }
        return false;
    }

    private String getCurrentMacJreVersion() {
        File infoPlist = new File(this.destinationDirectory, "Contents/Info.plist");
        if (infoPlist.exists()) {
            try {
                Document document = XmlHelper.parseFile(infoPlist);
                Element element = document.getDocumentElement();
                return XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(element, "dict"), "CFBundleVersion"));
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
        return null;
    }

    public long getJreSize() throws IOException {
        if (this.jreSize == -1L) {
            this.initJreSizeAndCount();
        }
        return this.jreSize;
    }

    private void initJreSizeAndCount() throws IOException {
        if (InstallerUtil.isWindows()) {
            File jreDir = InstallerUtil.getAbsoluteFile(new File(JRE_DIR));
            this.jreSize = JreInstaller.countSize(jreDir);
            this.jreCount = JreInstaller.countFilesAndDirs(jreDir);
        } else if (Util.isMacosInstaller()) {
            this.jreSize = 0L;
            this.jreCount = 0;
            if (BUNDLED_MAC_TAR_FILE != null || USED_MAC_JRE_BUNDLE != null && !USED_MAC_JRE_BUNDLE.startsWith("/System") && !USED_MAC_JRE_BUNDLE.startsWith("/Library")) {
                File jreDir = InstallerUtil.getAbsoluteFile(new File(USED_MAC_JRE_BUNDLE));
                this.jreSize = JreInstaller.countSize(jreDir);
                this.jreCount = JreInstaller.countFilesAndDirs(jreDir);
            }
        } else {
            this.jreSize = 0L;
            this.jreCount = 0;
            File jreTarFile = InstallerUtil.getAbsoluteFile(new File(JRE_TAR));
            if (jreTarFile.exists()) {
                TarArchiveInputStream in = new TarArchiveInputStream(new BufferedInputStream(new FileInputStream(jreTarFile)));
                TarArchiveEntry entry = in.getNextTarEntry();
                while (entry != null) {
                    ++this.jreCount;
                    this.jreSize += entry.getSize();
                    entry = in.getNextTarEntry();
                }
            }
        }
    }

    public int getJreCount() throws IOException {
        if (this.jreCount == -1) {
            this.initJreSizeAndCount();
        }
        return this.jreCount;
    }

    private static int countFilesAndDirs(File dir) {
        int ret = 0;
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                ++ret;
                if (!child.isDirectory()) continue;
                ret += JreInstaller.countFilesAndDirs(child);
            }
        }
        return ret;
    }

    private static long countSize(File dir) {
        long ret = 0L;
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    ret += JreInstaller.countSize(child);
                    continue;
                }
                ret += child.length();
            }
        }
        return ret;
    }

    public void writePreferredJre(File runtimeDir) throws UserCanceledException, IOException {
        String variableValue;
        this.writeOneLineFile(new File(runtimeDir, "inst_jre.cfg"), System.getProperty("java.home"));
        this.preferredJreFile = new File(runtimeDir, "pref_jre.cfg");
        if (this.preferredJre != null) {
            this.writeOneLineFile(this.preferredJreFile, this.preferredJre);
        }
        if (this.preferredJre == null) {
            variableValue = System.getProperty("java.home");
        } else if (Util.isMacOS() && this.preferredJre.endsWith(".bundle")) {
            variableValue = this.preferredJre + "/Contents/Home/jre";
            if (!new File(variableValue).isDirectory()) {
                variableValue = this.preferredJre + "/Contents/Home";
            }
        } else {
            variableValue = this.preferredJre;
        }
        this.setPreferredJreVariable(variableValue);
    }

    private void setPreferredJreVariable(String variableValue) {
        InstallerVariables.setVariable("sys.preferredJre", variableValue);
    }

    public void setPreferredJre(String preferredJre) {
        this.preferredJre = preferredJre;
        this.setPreferredJreVariable(preferredJre);
        if (preferredJre != null && this.preferredJreFile != null) {
            try {
                this.writeOneLineFile(this.preferredJreFile, preferredJre);
            }
            catch (UserCanceledException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeOneLineFile(File file, String line) throws IOException, UserCanceledException {
        this.fileInstaller.createDirectory(file.getParentFile());
        File tempFile = File.createTempFile("i4j", null);
        PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
        pw.println(line);
        pw.close();
        FileInstaller.getInstance().install(tempFile, file, new FileOptions("644", OverwriteMode.ALWAYS, false));
        tempFile.delete();
    }

    public void cleanup() {
        File backupDir;
        if (this.destinationDirectory != null && (backupDir = new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR)).exists()) {
            FileUtil.deleteDirectory(backupDir);
        }
    }

    public void rollback() {
        File backupDir;
        if (this.destinationDirectory != null && (backupDir = new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR)).exists()) {
            FileUtil.deleteDirectory(this.destinationDirectory);
            if (!backupDir.renameTo(this.destinationDirectory)) {
                this.destinationDirectory.mkdirs();
                try {
                    FileUtil.copyDirectory(backupDir, this.destinationDirectory, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FileUtil.deleteDirectory(backupDir);
            }
        }
    }
}

